@extends('backend.layouts.master')
@section('content')            
    <div class="container-fluid">
        <div class="row">
            <div class="col-sm-12">
                @include('backend.services.features.menu')
            </div>
            <div class="col-sm-12 col-lg-12">
                <div class="iq-card">
                    <div class="iq-card-header d-flex justify-content-between">
                        <div class="iq-header-title">
                            <h4 class="card-title">Edit Services Features</h4>
                        </div>
                    </div>
                    <div class="iq-card-body">
                        @if (count($errors) > 0)
                            <div class="alert alert-danger">
                                <ul>
                                    @foreach ($errors->all() as $error)
                                        <li>{{ $error }}</li>
                                    @endforeach
                                </ul>
                            </div>
                        @endif

                        @if(isset($features)) 
                        <form action="{{ route('admin.services.features.update') }}" method="post" enctype="multipart/form-data" id="frm_productphoto">
                        @csrf
                        <input type="hidden" id="id" name="id" value="{{ $features->id }}" />

                        <div class="row mb-3">
                            <div class="col-md-12">
                                <label for="caption">Caption:</label>
                                <input type="text" class="form-control" id="caption" name="caption" value="{{ $features->caption }}" />
                                <div class="error" id="error_caption"></div>
                            </div>
                        </div>

                        <div class="row mb-3">
                            <div class="col-md-6">
                                <label for="photo">Photo:</label>
                                <input type="file" class="form-control" id="photo" name="photo" accept="image/*" />
                            </div>
                            <div class="col-md-6" style="background:#000; padding:3px; border-radius:5px;">
                                @if($features->photo)
                                    <img src="{{ asset('storage/assets/services/features/' . $features->photo) }}" width="100" alt="Featues Photo" />
                                @endif
                            </div>
                        </div>
                        
                        <div class="row mb-3">
                            <div class="col-md-12">
                                <label for="description">Description:</label> <!-- Corrected label -->
                                <textarea class="form-control ckeditor" id="description" name="description">{{ $features->description }}</textarea>
                                <div class="error" id="error_description"></div>
                            </div>
                        </div>

                        <div class="form-group">
                            <button type="submit" class="btn btn-primary">Submit</button>
                            <a href="{{ route('admin.services.features.view', ['id' => $features->id]) }}" class="btn btn-danger">Cancel</a>
                        </div>
                    </form>
                   
                        @endif
                    </div>
                </div>
            </div>
        </div>
    </div>

    <script src="https://cdn.jsdelivr.net/npm/sweetalert2@11/dist/sweetalert2.all.min.js"></script>
    <script type="text/javascript">
        $.ajaxSetup({
            headers: {
                'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
            }
        });

        $(document).ready(function() {
            $("#frm_productphoto").submit(function(event) {
                event.preventDefault();
                var formData = new FormData(this);
                var descriptionData = CKEDITOR.instances.description.getData();
                formData.append('description', descriptionData);
                formData.append('services_id', $('#services_id').val());
                var isValid = true;
              
                if ($("#caption").val() == "") {
                    $("#error_caption").html("Caption is required.");
                    isValid = false;
                } else {
                    $("#error_caption").html("");  
                }

                if ($("#description").val() == "") {
                    $("#error_description").html("Description is required.");
                    isValid = false;
                } else {
                    $("#error_description").html("");  
                }

                if (isValid) {  
                    Swal.fire({
                        title: 'Do you want to update the record?',
                        icon: 'warning',
                        showCancelButton: true,
                        confirmButtonColor: '#3085d6',
                        cancelButtonColor: '#d33',
                        confirmButtonText: 'Yes, Continue'
                    }).then((result) => {
                        if (result.isConfirmed) {            
                            var url = $('#frm_productphoto').attr('action');
                            
                            $.ajax({
                                type: 'POST',
                                url: url,
                                data: formData,
                                contentType: false,
                                processData: false,
                                success: function(response) {
                                    if (response.success) {                                                 
                                        Swal.fire({
                                            icon: 'success',
                                            title: 'Services Features',
                                            text: 'Services Features updated successfully!',
                                        }).then(function() {
                                            // Redirect with the correct ID
                                            window.location.href = '{{ route("admin.services.features.view", ["id" => $features->services_id]) }}';
                                       
                                          });                          
                                    } else {
                                        Swal.fire({
                                            photo: 'error',
                                            title: 'Services Features',
                                            text: 'Error occurred. Retry again.',
                                        });
                                    }
                                },
                                error: function() {
                                    Swal.fire({
                                        icon: 'error',
                                        title: 'Services Features',
                                        text: 'Error submitting the form!',
                                    });
                                }                                       
                            });  
                        }
                    });
                }
            });
        });
    </script>
@endsection
