@extends('backend.layouts.master')
@section('content')

<div class="container-fluid">
    <div class="row">
        <div class="col-sm-12">
            @include('backend.services.features.menu')
        </div>
        <div class="col-sm-12 col-lg-12">
            <div class="iq-card">
                <div class="iq-card-body">
                    @if (count($errors) > 0)
                    <div class="alert alert-danger">
                        <ul>
                            @foreach ($errors->all() as $error)
                            <li>{{ $error }}</li>
                            @endforeach
                        </ul>
                    </div>
                    @endif

                    <form action="{{ route('admin.services.features.insert') }}" method="post" enctype="multipart/form-data" id="frm_servicesphoto">
                        @csrf

                        <div class="container-fluid">
                            <div class="row">
                            <div class="form-group col-sm-6">
                                <label for="caption">Caption</label>
                                <input type="text" class="form-control" id="caption" name="caption" value="{{ old('caption') }}" />
                                <span class="error" id="error_caption"></span>
                            </div> 
                            <div class="form-group col-sm-6">
                                <label for="photo">Photo</label>
                                <input type="file" class="form-control" id="photo" name="photo" value="{{ old('photo') }}" />
                                <span class="error" id="error_photo"></span>
                            </div> 
                            </div> 
    
                            <div class="form-group col-sm-12">
                                <label for="description">Description</label>
                                <textarea class="form-control ckeditor" id="description" name="description">{{ old('description') }}</textarea>
                                <span class="error" id="error_description"></span>
                            </div> 
                            <input type="hidden" name="services_id" id="services_id" value="{{ $services_id }}" />
                            <div class="form-group">
                                <button type="submit" class="btn btn-primary">Submit</button>
                                <button type="button" class="btn iq-bg-danger" onclick="window.location.href='{{ route('admin.services.features.view', ['id' => $services_id]) }}'">Cancel</button>
                            </div>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
</div>

<div class="container-fluid">
    <div class="row">
        @if(isset($services))
        <div class="col-sm-12">
            <input type="hidden" class="form-control" id="services_id" name="services_id" value="{{ $services_id }}" />
        </div>
        @endif

        <div class="col-sm-12">
            <div class="iq-card">
                <div class="iq-card-body">
                    <div id="table" class="table-editable">
                        <table class="table table-bordered table-responsive-md table-striped" id="features">
                            <thead>
                                <tr>
                                    <th>Sl No.</th>
                                    <th>Caption</th>
                                    <th>Photo</th>
                                  <th width="20%">Action</th>
                                </tr>
                            </thead>
                            <tbody>
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>


<script type="text/javascript">
$(document).ready(function() {
    $.ajaxSetup({
        headers: {
            'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
        }
    });

    var servicesId = $('#services_id').val();

    var table = $('#features').DataTable({
        processing: true,
        serverSide: true,
        ajax: {
            url: "{{ route('admin.services.features.ajaxviewphotos') }}",
            type: "POST",
            data: { services_id: servicesId } 
        },
        columns: [
            { data: 'DT_RowIndex', name: 'DT_RowIndex' },
            { data: 'caption', name: 'caption' },
            { data: 'photo', name: 'photo', orderable: false, searchable: false },
            { data: 'action', name: 'action', orderable: false, searchable: false }
        ]
    });

    // Delete function
    window.deletefeatures = function(id) {
        Swal.fire({
            title: 'Do you want to delete the record?',
            text: 'This action cannot be undone.',
            icon: 'warning',
            showCancelButton: true,
            confirmButtonColor: '#3085d6',
            cancelButtonColor: '#d33',
            confirmButtonText: 'Yes, Delete'
        }).then((result) => {
            if (result.isConfirmed) {
                var url = '{{ route("admin.services.features.delete", ":id") }}'.replace(':id', id);
                $.ajax({
                    type: 'DELETE',
                    url: url,
                    success: function(response) {
                        if (response.success) {
                            Swal.fire({
                                icon: 'success',
                                title: 'Deleted!',
                                text: 'Services Features deleted successfully!'
                            }).then(() => {
                                table.ajax.reload();
                            });
                        } else {
                            Swal.fire('Error', response.message, 'error');
                        }
                    },
                    error: function() {
                        Swal.fire('Error', 'Error deleting the record!', 'error');
                    }
                });
            }
        });
    };
        $("#frm_servicesphoto").submit(function(event) {
        event.preventDefault();
        var formData = new FormData(this);

        // ✅ CKEditor description
        var descriptionData = CKEDITOR.instances.description.getData();
        formData.append('description', descriptionData);

        var isValid = true;

        if ($("#caption").val() == "") {
            $("#error_caption").html("Caption is required.");
            isValid = false;
        } else {
            $("#error_caption").html("");  
        }


        if (isValid) {

            Swal.fire({
                title: 'Do you want to submit?',
                icon: 'warning',
                showCancelButton: true,
                confirmButtonText: 'Yes, Continue'
            }).then((result) => {
                if (result.isConfirmed) {

                    $.ajax({
                        type: 'POST',
                        url: "{{ route('admin.services.features.insert') }}",
                        data: formData,
                        contentType: false,
                        processData: false,
                        success: function(response) {
                            if (response.success) {
                                Swal.fire('Success!', 'Services Features added successfully!', 'success')
                                    .then(() => {
                                        window.location.href = '{{ route("admin.services.features.view", ["id" => $services_id]) }}';
                                    });
                            } else {
                                Swal.fire('Error', 'Error occurred. Retry again.', 'error');
                            }
                        },
                        error: function() {
                            Swal.fire('Error', 'Error submitting the form!', 'error');
                        }
                    });
                }
            });
        }
    });
});


</script>


@endsection
