@extends('backend.layouts.master')
@section('content')           
<div class="container-fluid">
   <div class="row">
      <div class="col-sm-12">
         @include('backend.testimonial.menu')
      </div>
      <div class="col-sm-12 col-lg-12">
         <div class="iq-card">
            <div class="iq-card-header d-flex justify-content-between">
               <div class="iq-header-title">
                  <h4 class="card-title">Edit Testimonial</h4>
               </div>
            </div>
            <div class="iq-card-body">
               @if (count($errors) > 0)
               <div class="alert alert-danger">
                  <ul>
                     @foreach ($errors->all() as $error)
                     <li>{{ $error }}</li>
                     @endforeach
                  </ul>
               </div>
               @endif
               @if(isset($testimonial)) 
               
               <form action="{{ route('admin.testimonial.update') }}" method="post" enctype="multipart/form-data" id="frm_testimonial">
                  @csrf
                  <input type="hidden" class="form-control" id="id" name="id" value="{{ $testimonial->id }}" />
                  <div class="container-fluid">
                     <div class="row">
                        <div class="form-group col-sm-12">
                           <label for="name">Name</label>
                           <input type="text" class="form-control" id="name" name="name" value="{{ $testimonial->name }}" />
                           <span class="error" id="error_name"></span>
                        </div>

                        <div class="form-group col-sm-12">
                           <label for="location">Location</label>
                           <input type="text" class="form-control" id="location" name="location" value="{{ $testimonial->location }}" />
                           <span class="error" id="error_location"></span>
                        </div>

                        <div class="form-group col-sm-12">
                           <label for="caption">Description</label>
                           <textarea type="text" class="form-control ckeditor" id="description" name="description">{{ $testimonial->description }}</textarea>
                           <span class="error" id="error_description"></span>
                        </div>
                        <div class="form-group col-sm-6">
                           <div class="col-md-6">
                              <label for="photo">Photo (750 X 600 pixels):</label>
                              <input type="file"  id="photo" name="photo"  width="300" />
                              <input type="hidden"  id="oldphoto" name="oldphoto"  value="{{ $testimonial->photo  }}" />
                              <span class="error" id="error_photo"></span>
                           </div>
                           <div class="col-md-6">
                              @if($testimonial->photo!="")
                              <img src="{{asset('storage/assets/testimonial/photo/')}}/{{ $testimonial->photo }}" width="100" />
                              @endif
                           </div>
                        </div>
                        <div class="form-group col-sm-6">
                           <label for="photo_text">Photo Text</label>
                           <input type="text" class="form-control" id="photo_text" name="photo_text" value="{{ $testimonial->photo_text }}" />
                           <span class="error" id="error_photo_text"></span>
                        </div>
                     </div> 
                  </div>
                  <div class="form-group col-sm-6">
                     <button type="submit" class="btn btn-primary">Update</button>
                  </div>
               </form>
                                     
               @endif  
            </div>
         </div>
      </div>
   </div>
</div>
<script type="text/javascript" language="javascript" class="init">
   $.ajaxSetup({
      headers: {
         'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
      }
   });
   
   $(document).ready(function() {
       $("#frm_testimonial").submit(function(event) {
           event.preventDefault();
           
           var formData = new FormData($("#frm_testimonial")[0]);
   
           var photoFile = $('#photo')[0].files[0];
           if (photoFile) {
               formData.append('photo', photoFile);
           }
           
           var descriptionData = CKEDITOR.instances.description.getData();
           formData.append('description', descriptionData);

           var isValid = true;
   
           if ($("#name").val() == "") {
               $("#error_name").html("Name is required.");
               isValid = false;
           } else {
               $("#error_name").html("");
           }
           
           if (isValid) {  
               Swal.fire({
                   title: 'Do you want to update the record?',
                   text: '',
                   icon: 'warning',
                   showCancelButton: true,
                   confirmButtonColor: '#3085d6',
                   cancelButtonColor: '#d33',
                   confirmButtonText: 'Yes, Continue'
               }).then((result) => {
                   if (result.isConfirmed) {
                       var url = $('#frm_testimonial').attr('action');
                       $.ajax({
                           type: 'POST',
                           processData: false,
                           contentType: false,
                           cache: false,
                           data: formData,
                           url: url,
                           success: function(response) {
                               if (response.success) {
                                   Swal.fire({
                                       icon: 'success',
                                       title: 'Testimonial',
                                       text: 'Testimonial updated successfully!',
                                   }).then(function() {
                                       window.location = "{{ route('admin.testimonial.view') }}";
                                   });                          
                               } else {
                                   Swal.fire({
                                       icon: 'error',
                                       title: 'Testimonial',
                                       text: 'Error Occurred. Retry again.',
                                   });
                               }
                           },
                           error: function(error) {
                               Swal.fire({
                                   icon: 'error',
                                   title: 'Testimonial',
                                   text: 'Error submitting the form!',
                               });
                           }
                       });  
                   }
               });
           }
       });
   });
   
</script>
@endsection