@extends('backend.layouts.master')

@section('content')
<div class="container-fluid">
    <div class="row">
    <div class="col-sm-12">
         @include('backend.users.menu')
      </div>
        <div class="col-sm-12 col-lg-12">
            <div class="iq-card">
                <div class="iq-card-header d-flex justify-content-between">
                    <div class="iq-header-title">
                        <h4 class="card-title">Edit Users</h4>
                    </div>
                </div>
                <div class="iq-card-body">
                    @if (count($errors) > 0)
                    <div class="alert alert-danger">
                        <ul>
                            @foreach ($errors->all() as $error)
                            <li>{{ $error }}</li>
                            @endforeach
                        </ul>
                    </div>
                    @endif

                    <form id="downloadRequestForm" method="POST" action="{{ route('admin.users.update') }}" enctype="multipart/form-data">
                        @csrf
                        <input type="hidden" name="id" value="{{ $users->id }}">

                        <!-- User PDF File -->
                        <div class="form-group col-sm-12">
                            <div class="row">
                                <div class="form-group col-sm-6">
                                    <label for="name">Name</label>
                                    <input type="text" class="form-control" id="name" name="name" value="{{ $users->name }}" />
                                    <span class="error" id="error_name"></span>
                                </div> 
                                <div class="form-group col-sm-6">
                                    <label for="name">Email</label>
                                    <input type="text" class="form-control" id="email" name="email" value="{{ $users->email }}" />
                                    <span class="error" id="error_email"></span>
                                </div> 
                            </div>
                        </div>

                        <!-- Submit Button -->
                        <div class="form-group">
                            <button type="submit" class="btn btn-primary">Update</button>
                            <a href="{{ route('admin.users.view') }}" class="btn btn-secondary">Cancel</a>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
</div>

<script type="text/javascript">
$(document).ready(function() {
    $("#downloadRequestForm").submit(function(event) {
        event.preventDefault();
        
        var formData = new FormData(this);
        var isValid = true;
        if ($("#name").val() == "") {
               $("#error_name").html("Name   is required.");
               isValid = false;
         } 
         else
         $("#error_name").html("");
	    if ($("#email").val() == "") {
               $("#error_email").html("Email   is required.");
               isValid = false;
         } 
         else
         $("#error_email").html("");

        if (isValid) {
            Swal.fire({
                title: 'Do you want to update the User?',
                icon: 'warning',
                showCancelButton: true,
                confirmButtonColor: '#3085d6',
                cancelButtonColor: '#d33',
                confirmButtonText: 'Yes, Continue'
            }).then((result) => {
                if (result.isConfirmed) {
                    $.ajax({
                        url: $(this).attr('action'),
                        type: 'POST',
                        data: formData,
                        processData: false,
                        contentType: false,
                        success: function(response) {
                            if (response.success) {
                                Swal.fire({
                                    icon: 'success',
                                    title: 'User',
                                    text: response.message,
                                }).then(function() {
                                    window.location.href = "{{ route('admin.users.view') }}";
                                });
                            } else {
                                Swal.fire({
                                    icon: 'error',
                                    title: 'Error',
                                    text: response.message,
                                });
                            }
                        },
                        error: function(error) {
                            Swal.fire({
                                icon: 'error',
                                title: 'Error',
                                text: 'An error occurred. Please try again later.',
                            });
                        }
                    });
                }
            });
        }
    });
});
</script>
@endsection
