@extends('frontend.layouts.master')
@php $page= "about" @endphp
@section('content')

    <section class="innerpage-header-wrap">
        <div class="container">
            <div class="banner-video-wrapper">
                 <video class="banner-video" autoplay="" muted="" loop="" playsinline="" preload="auto" postersrc="{{ asset('assets/frontend/img/banner-left-bg.jpg')}}">
                    <source src="video/bannervideo.webm" type="video/webm">
                    <img src="{{ asset('assets/frontend/img/banner-left-bg.jpg')}}" alt="Banner Background">
                </video>
            </div>
            <div class="row">
                <div class="col-lg-6">
                    <div class="innerpage-banner-heading">
                        <div class="innerpage-middlealign">
                            <h1>About Us</h2>
                            <nav aria-label="breadcrumb">
                                <ol class="breadcrumb">
                                    <li class="breadcrumb-item"><a href="{{ route('frontend.home') }}"><i class="fa-solid fa-house"></i> Home</a></li>
                                    <li class="breadcrumb-item active" aria-current="page">About Us</li>
                                </ol>
                            </nav>
                        </div>
                    </div>
                </div>
            </div>
            <img src="{{ asset('assets/frontend/img/about-banner.jpg')}}" alt="YESTE About Us" class="banner-image">
        </div>
    </section>



    
    <section class="whoweare-contanier">
        <div class="container">
            <div class="row">
                <div class="col-xl-7 col-lg-7 pe-lg-5">
                    <div class="whoweare-wrap">
                        <span>
                            <h2>Who We Are</h2>
                          <p>{!!  html_entity_decode($about->who_we_are) !!}</span>
                    </div>
                </div>
                <div class="col-xl-5 col-lg-5 ps-lg-4"><img src="{{asset('storage/assets/about/photo/'.$about->photo)}}" alt="{{ $about->photo_text }}"></div>
            </div>

            <div class="row">
                <div class="col-lg-12">
                    <div class="history-wrapper-div">
                        <img class="history-icon" src="{{asset('storage/assets/about/our_history_icon/'.$about->our_history_icon)}}" alt="{{ $about->our_history_icon_text }}">
                        <h3>Our History</h3>
                        {!!  html_entity_decode($about->our_history) !!}  </div>
                </div>
            </div>
        </div>
    </section>


    <section class="history-vision-wrapper">
        <div class="container">
            <div class="row">
                <div class="col-xl-6 col-lg-6">
                    <div class="mission-history-item">
                        <h2>Our Mission</h2>
                        {!!  html_entity_decode($about->mission) !!}
                    </div>
                </div>
                <div class="col-xl-6 col-lg-6">
                    <div class="mission-history-item">
                        <h2>Our Vision</h2>
                    {!!  html_entity_decode($about->vision) !!}
                    </div>
                </div>
            </div>
        </div>
    </section>

    <section class="ourvalues-contanier">
        <div class="container">
            <div class="row">
                <div class="col-xl-12">
                    <h2>Our Values</h2>
                    <p>At YESTE Global, we stand on three core values that guide every service we provide:</p>
                </div>
            </div>
            <div class="row justify-content-center">
                @foreach($features as $feature1)
                <div class="col-xl-4 col-lg-4 col-md-6">
                    <div class="ourvalues-item">
                        <span><img src="{{asset('storage/assets/about/features/'.$feature1->photo)}}" alt="Photo"></span>
                        <h4>{{ $feature1->caption }}</h4>
                         {!!  html_entity_decode($feature1->description) !!}  
                    </div>
                </div>
                @endforeach
            </div>
        </div>
    </section>


    <div class="container">
        <div class="global-presence">
           <img class="global-presence-icon" src="{{asset('storage/assets/about/global_presence_icon/'.$about->global_presence_icon)}}" alt="{{ $about->global_presence_icon_text }}">
            <h3>Global Presence</h3>
        {!!  html_entity_decode($about->global_presence) !!}  
  </div>
    </div>
    

    <section class="whatwedo-wrapper">
        <div class="container">
            <div class="row">
                <div class="col-xl-6 col-lg-6">
                    <div class="whatwedo-item">
                        <h3>What We Do</h3>
                         {!!  html_entity_decode($about->what_we_do) !!}  

                    </div>
                </div>
                <div class="col-xl-6 col-lg-6">
                    <div class="whatwedo-item">
                        <h3>The YESTE Advantage</h3>
                    {!!  html_entity_decode($about->advantages) !!} 

                    </div>
                </div>
            </div>
        </div>
    </section>

   

@endsection