@extends('frontend.layouts.master')
@php $page= "applynow" @endphp
@section('content')
@php
    use Carbon\Carbon;
@endphp

<!-- SweetAlert2 CSS (optional - included automatically by the script too) -->
<link href="https://cdn.jsdelivr.net/npm/sweetalert2@11/dist/sweetalert2.min.css" rel="stylesheet">

<!-- SweetAlert2 JS -->
<script src="https://cdn.jsdelivr.net/npm/sweetalert2@11/dist/sweetalert2.all.min.js"></script>


    <section class="innerpage-header-wrap">
        <div class="container">
            <div class="banner-video-wrapper">
                 <video class="banner-video" autoplay="" muted="" loop="" playsinline="" preload="auto" poster="img/banner-left-bg.jpg">
                    <source src="video/bannervideo.webm" type="video/webm">
                    <img src="img/banner-left-bg.jpg" alt="Banner Background">
                </video>
            </div>
            <div class="row">
                <div class="col-lg-6">
                    <div class="innerpage-banner-heading">
                        <div class="innerpage-middlealign">
                            <h1>Apply Now</h2>
                            <nav aria-label="breadcrumb">
                                <ol class="breadcrumb">
                                    <li class="breadcrumb-item"><a href="index.php"><i class="fa-solid fa-house"></i> Home</a></li>
                                    <li class="breadcrumb-item active" aria-current="page">Apply Now</li>
                                </ol>
                            </nav>
                        </div>
                    </div>
                </div>
            </div>
            <img src="img/findjobs-banner.jpg" alt="Yeste Leadership" class="banner-image">
        </div>
    </section>



    <section class="innerpage-contanier applynowpage-wrap">
        <div class="container">
            
        <div class="row justify-content-center">
            <div class="col-lg-8">
                <div class="applynow-headings">
                    <h3>Apply Now & Grow with Us</h3>
                    <p>We’re excited to learn more about you - complete the form below to get started.</p>
                </div>
                
                <form action="{{ route('frontend.applynow.submit') }}" method="POST" enctype="multipart/form-data"> 
                @csrf
                <input type="hidden" value="{{ $job_id }}" name="job_id" id="job_id" />
                    <h4>Personal Information</h4>
                    <div class="row">
                        <div class="col-lg-6 col-md-6">
                            <div class="applynowform-item">
                            <label>First Name<span class="redcolor">*</span></label>
                            <input type="text" id="first_name" name="first_name" />
                            <span class="error_msg" id="error_first_name"></span>
                            </div>
                        </div>
                         <div class="col-lg-6 col-md-6">
                            <div class="applynowform-item">
                            <label>Last Name<span class="redcolor">*</span></label>
                            <input type="text" id="last_name" name="last_name">
                            <span class="error_msg" id="error_last_name"></span>
                            </div>
                        </div>
                         <div class="col-lg-6 col-md-6">
                            <div class="applynowform-item">
                            <label>Phone<span class="redcolor">*</span></label>
                            <input type="text" name="phone" id="phone">
                            <span class="error_msg" id="error_phone"></span>
                            </div>
                        </div>
                        <div class="col-lg-6 col-md-6">
                            <div class="applynowform-item">
                            <label>Email<span class="redcolor">*</span></label>
                            <input type="text" id="email" name="email">
                            <span class="error_msg" id="error_email"></span>
                            </div>
                        </div>
                        
                        
                        <div class="col-lg-6 col-md-6">
                            <div class="applynowform-item">
                            <label>Year Of Experience<span class="redcolor">*</span></label>
                            <select name="year_of_experience" id="year_of_experience">
                            <option value="">Select</option>
                             @if(isset($Year_Of_Experience) && count($Year_Of_Experience) > 0)
                                @foreach($Year_Of_Experience as $exp)
                                    <option value="{{ $exp['actual_value'] }}">{{ $exp['display_value'] }}</option>
                                @endforeach
                            @endif
                            </select>
                            <span class="error_msg" id="error_year_of_experience"></span>
                            </div>
                        </div>
                       
                        
                        <div class="col-lg-6 col-md-6">
                            <div class="applynowform-item">
                            <label>Current Experience<span class="redcolor">*</span></label>
                           <select name="current_experience" id="current_experience">
                            <option value="">Select</option>
                        
                            @if(isset($Current_Experience) && count($Current_Experience) > 0)
                                @foreach($Current_Experience as $exp)
                                    <option value="{{ $exp['actual_value'] }}">{{ $exp['display_value'] }}</option>
                                @endforeach
                            @endif
                        </select>

                            <span class="error_msg" id="error_current_experience"></span>
                            </div>
                        </div>
                         <div class="col-lg-6 col-md-6">
                            <div class="applynowform-item">
                            <label>AHPRA Status<span class="redcolor">*</span></label>
                             <select name="aphra_status" id="aphra_status">
                            <option value="">Select</option>
                             @if(isset($AHPRA_Registration) && count($AHPRA_Registration) > 0)
                                @foreach($AHPRA_Registration as $status)
                                    <option value="{{ $status['actual_value'] }}">{{ $status['display_value'] }}</option>
                                @endforeach
                            @endif
                            </select>
                            <span class="error_msg" id="error_aphra_status"></span>
                            </div>
                        </div>
                        
                         <div class="col-lg-6">
                            <div class="applynowform-item uploadresume">
                            <label>Upload Resume (Max 5MB)</label>
                            <input type="file" name="resume" id="resume" >
                            <span class="error_msg" id="error_resume"></span>
                            </div>
                        </div>
                        
                        
                    </div>

                 

                    <h4>Additional Info</h4>
                    <div class="row">
                    
                        <div class="col-lg-12 agree-terms">
                            <p><label><input type="checkbox" id="accurate" name="accurate"> I confirm the details provided are accurate.</label></p>
                            <p><label><input type="checkbox" id="privacy" name="privacy"> I agree to the <a href="#">privacy policy</a>.</label></p>  
                            
                            <span class="error_msg" id="error_checkbox"></span>
                        </div>
                    </div>

                    <div class="row justify-content-center">
                        <div class="col-lg-4 col-md-4">
                            <button class="submit-application" type="submit">Submit Application</button>
                        </div>
                    </div>
                </form>
            </div>
        </div>
            
        </div>
    </section>
<script>
$(document).ready(function () {

    $(".submit-application").click(function (e) {
        e.preventDefault();

        let valid = true;
        $(".error_msg").hide().text("");

        // First Name
        if ($("#first_name").val().trim() === "") {
            $("#error_first_name").text("First name is required").show();
            valid = false;
        }

        // Last Name
        if ($("#last_name").val().trim() === "") {
            $("#error_last_name").text("Last name is required").show();
            valid = false;
        }

        // Phone
        let phone = $("#phone").val().trim();
        let phoneRegex = /^[0-9]{7,15}$/;

        if (phone === "") {
            $("#error_phone").text("Phone number is required").show();
            valid = false;
        } else if (!phoneRegex.test(phone)) {
            $("#error_phone").text("Enter a valid phone number").show();
            valid = false;
        }

        // Email
        let email = $("#email").val().trim();
        let emailRegex = /^\S+@\S+\.\S+$/;

        if (email === "") {
            $("#error_email").text("Email is required").show();
            valid = false;
        } else if (!emailRegex.test(email)) {
            $("#error_email").text("Enter a valid email address").show();
            valid = false;
        }

        // Year of Experience
        if ($("#year_of_experience").val() === "") {
            $("#error_year_of_experience").text("Select Year Of Experience").show();
            valid = false;
        }

        // Current Experience
        if ($("#current_experience").val() === "") {
            $("#error_current_experience").text("Select Current Experience").show();
            valid = false;
        }

        // AHPRA Status
        if ($("#aphra_status").val() === "") {
            $("#error_aphra_status").text("Select AHPRA Status").show();
            valid = false;
        }

        // Resume (OPTIONAL, but size <= 5MB)
        let resumeInput = document.getElementById("resume");
        if (resumeInput.files.length > 0) {
            let fileSize = resumeInput.files[0].size; // bytes
            let maxSize = 5 * 1024 * 1024; // 5MB

            if (fileSize > maxSize) {
                $("#error_resume").text("Resume size must be less than 5MB").show();
                valid = false;
            }
        }

        // Checkboxes
        if (!$("#accurate").is(":checked") || !$("#privacy").is(":checked")) {
            $("#error_checkbox").text("You must agree to both statements").show();
            valid = false;
        }

        // Error popup
        if (!valid) {
            Swal.fire({
                icon: "error",
                title: "Form Incomplete",
                text: "Please fix the highlighted errors."
            });
            return;
        }

        // Submit
        Swal.fire({
            icon: "success",
            title: "Submitting...",
            text: "Your application is being submitted.",
            timer: 1500,
            showConfirmButton: false
        }).then(() => {
            $("form")[0].submit();
        });

    });

});
</script>


@endsection