@extends('frontend.layouts.master')
@php $page= "blogs" @endphp
@section('content')
    <section class="innerpage-header-wrap">
        <div class="container">
            <div class="banner-video-wrapper">
                 <video class="banner-video" autoplay="" muted="" loop="" playsinline="" preload="auto" poster="img/banner-left-bg.jpg')}}">
                    <source src="{{ asset('assets/frontend/video/bannervideo.webm')}}" type="video/webm">
                    <img src="{{ asset('assets/frontend/img/banner-left-bg.jpg')}}" alt="Banner Background">
                </video>
            </div>
            <div class="row">
                <div class="col-lg-6">
                    <div class="innerpage-banner-heading">
                        <div class="innerpage-middlealign">
                            <h1>Blog</h2>
                            <nav aria-label="breadcrumb">
                                <ol class="breadcrumb">
                                    <li class="breadcrumb-item"><a href="{{ route('frontend.home') }}"><i class="fa-solid fa-house"></i> Home</a></li>
                                    <li class="breadcrumb-item" aria-current="page"><a href="blog.php">Blog</a></li>
                                    <li class="breadcrumb-item active" aria-current="page">Top 10 Tips for Landing Your First International Job</li>
                                </ol>
                            </nav>
                        </div>
                    </div>
                </div>
            </div>
            <img src="{{ asset('assets/frontend/img/testimonials-banner.jpg')}}" alt="Yeste Leadership" class="banner-image">
        </div>
    </section>


@if(isset($blog))
    <section class="innerpage-contanier blogsingle-wrapper">
        <div class="container">
            
            <div class="row">
                <div class="col-lg-8 pe-lg-5">
                    <div class="blog-heading-wrap">
                        <h6><span><i class="fa-solid fa-calendar-days"></i>{{ date('d-M-Y', strtotime($blog->created_at)) }}</span> <span><i class="fa-solid fa-user"></i> {{ $blog->auther }}</span></h6>
                        <h2>{{ $blog->caption }}</h2>
                    </div>

                   {!! html_entity_decode($blog->small_description) !!}
                   {!! html_entity_decode($blog->description) !!}


                </div>
                <div class="col-lg-4 ps-lg-4">
                    <div class="sidebar-sticky">
                        <div class="blog-image"><img src="{{asset('storage/assets/blog/'.$blog->photo)}}" alt="{{ $blog->photo_text }}"></div>
                        <div class="recentblog-wrapper">
                            <h4>Recent Blog</h4>
                            <ul>
                                @foreach($blogall as $blogall1)
                                <li><a href="{{ route('frontend.blog', $blogall1->seo_url) }}">{{ $blogall1->caption }}</a></li>
                                @endforeach  
                            </ul>
                        </div>
                    </div>
                </div>
            </div>
            
        </div>
    </section>
@endif


@endsection