@extends('frontend.layouts.master')
@php $page= "blogs" @endphp
@section('content')
    <section class="innerpage-header-wrap">
        <div class="container">
            <div class="banner-video-wrapper">
                 <video class="banner-video" autoplay="" muted="" loop="" playsinline="" preload="auto" poster="img/banner-left-bg.jpg')}}">
                    <source src="{{ asset('assets/frontend/video/bannervideo.webm')}}" type="video/webm">
                    <img src="{{ asset('assets/frontend/img/banner-left-bg.jpg')}}" alt="Banner Background">
                </video>
            </div>
            <div class="row">
                <div class="col-lg-6">
                    <div class="innerpage-banner-heading">
                        <div class="innerpage-middlealign">
                            <h1>Blog</h2>
                            <nav aria-label="breadcrumb">
                                <ol class="breadcrumb">
                                    <li class="breadcrumb-item"><a href="{{ route('frontend.home') }}"><i class="fa-solid fa-house"></i> Home</a></li>
                                    <li class="breadcrumb-item active" aria-current="page">Blog</li>
                                </ol>
                            </nav>
                        </div>
                    </div>
                </div>
            </div>
            <img src="{{ asset('assets/frontend/img/testimonials-banner.jpg')}}" alt="Yeste Leadership" class="banner-image">
        </div>
    </section>



    <section class="innerpage-contanier">
        <div class="container">
            
            <div class="row">
                @foreach($blogs as $blog)
                <div class="col-lg-4 col-md-6">
                    <a href="{{ route('frontend.blog', $blog->seo_url) }}" class="blog-item-wrapper">
                        <div class="blog-item-heading">
                            <h6><span>{{ date('d-M-Y', strtotime($blog->created_at)) }}</span></h6>
                            <h4><font>{{ $blog->caption }}</font></h4>
                            <p>{!! strip_tags($blog->small_description) !!}</p>
                        </div>
                        <div class="blog-item-image"><img src="{{asset('storage/assets/blog/'.$blog->photo)}}" alt="{{ $blog->photo_text }}"></div>
                    </a>
                </div>
                @endforeach
            </div>
            
        </div>
    </section>
@endsection