@extends('frontend.layouts.master')
@php $page= "Contact" @endphp
@section('content')
    <section class="innerpage-header-wrap">
        <div class="container">
            <div class="banner-video-wrapper">
                 <video class="banner-video" autoplay="" muted="" loop="" playsinline="" preload="auto" poster="img/banner-left-bg.jpg')}}">
                    <source src="video/bannervideo.webm" type="video/webm">
                    <img src="{{ asset('assets/frontend/img/banner-left-bg.jpg')}}" alt="Banner Background">
                </video>
            </div>
            <div class="row">
                <div class="col-lg-6">
                    <div class="innerpage-banner-heading">
                        <div class="innerpage-middlealign">
                            <h1>Contact Us</h2>
                            <nav aria-label="breadcrumb">
                                <ol class="breadcrumb">
                                    <li class="breadcrumb-item"><a href="{{ route('frontend.home') }}"><i class="fa-solid fa-house"></i> Home</a></li>
                                    <li class="breadcrumb-item active" aria-current="page">Contact Us</li>
                                </ol>
                            </nav>
                        </div>
                    </div>
                </div>
            </div>
            <img src="{{ asset('assets/frontend/img/contact-banner.jpg')}}" alt="YESTE About Us" class="banner-image">
        </div>
    </section>


    <section class="contact-topsection">
        <div class="container">
            
            <div class="row">
                <div class="col-lg-4 pe-lg-4">
                    <div class="contactleft-side">
                        <h3>Reach Out - <br>
                            The World Awaits You</h3>
                        
                        <p><b>YESTE Global Pty Ltd</b> <br>
                        26 Ranfurlie Drive Glen Waverly Victoria - 3150</p>

                        <hr>

                        <p>2nd Floor, Kattuveetil, 
                        Building M C Road, Road, opposite to Passport Office P.O, S.H. Mount,
                        Nagampadam, Kottayam, Kerala 686006, India</p>

                        <hr>

                        <h6><i class="fa-solid fa-phone"></i> Phone: <a href="tel:+917736377714">+91 7736377714</a></h6>
                        <h6><i class="fa-brands fa-whatsapp"></i> WhatsApp: <a href="tel:+61404380456 ">+61 404380456 </a></h6>
                        <h6><i class="fa-regular fa-envelope"></i> Email: <a href="mailto:recruitment@yesteglobal.com">recruitment@yesteglobal.com</a></h6>
                    </div>
                </div>
                <div class="col-lg-8 ps-lg-5 contactform">
                    <div class="contactform-heading">
                        <h3>From Enquiry to <br>
                        Opportunity - We’re Listening</h3>
                        <p>Every great success story starts with one small step - let your message to us be that step, and together we’ll shape a future that connects you with opportunities around the globe.</p>
                    </div>
                    <form action="{{ route('frontend.contactsubmit') }}" method="post" id="contact">
                        @csrf
                        <div class="row">
                        <div class="col-lg-6 col-md-6">
                            <input type="text" id="name" name="name" placeholder="Your Name" class="form-control" required>
                            <span class="error" id="error_name"></span>
                        </div>

                        <div class="col-lg-6 col-md-6">
                            <input type="email" id="email" name="email" placeholder="Email" class="form-control" required>
                            <span class="error" id="error_email"></span>
                        </div>

                        <div class="col-lg-6 col-md-6">
                            <input type="text" id="phone" name="phone" placeholder="Phone" class="form-control" required>
                            <span class="error" id="error_phone"></span>
                        </div>

                        <div class="col-lg-6 col-md-6">
                            <input type="text" id="subject" name="subject" placeholder="Subject" class="form-control" required>
                            <span class="error" id="error_subject"></span>
                        </div>

                        <div class="col-lg-12">
                            <textarea id="message" name="message" placeholder="Message" class="form-control" required></textarea>
                            <span class="error" id="error_message"></span>
                        </div>

                        <div class="col-lg-12">
                            {!! NoCaptcha::renderJs() !!}
                            {!! NoCaptcha::display() !!}
                        </div>
                            <div class="col-lg-4 col-md-4">
                                <button type="submit" class="viewmore-btnstyle">
                                    Submit <font><i class="fa-solid fa-angles-right"></i></font>
                                </button>
                            </div>
                        </div>
                    </form>

                </div>
            </div>

        </div>
    </section>

    <section class="faq-wrappersection">
        <div class="container">
            <div class="row justify-content-center">
                <div class="col-lg-8">
                    <div class="heading-styles">
                    <h6>Frequently Asked Questions</h6>
                    <h2>We’ve Got the Answers</h2>
                    <p>Explore our FAQ section to get detailed, clear, and instant answers to all the questions you might have about careers, migration, study, and global opportunities.</p>
                    </div>
                    <a href="{{ route('frontend.faq') }}" class="viewmore-btnstyle">View FAQ <font><i class="fa-solid fa-angles-right"></i></font></a>
                </div>
            </div>
        </div>
    </section>


    <section>
        <div class="container">
            <div class="googlemap-wrapper">
                <iframe src="https://www.google.com/maps/embed?pb=!1m18!1m12!1m3!1d3148.5173560742746!2d145.16506687663096!3d-37.89496843868461!2m3!1f0!2f0!3f0!3m2!1i1024!2i768!4f13.1!3m3!1m2!1s0x6ad64682570b069b%3A0x3243093e99061060!2sYESTE%20Consulting%20Pty%20Ltd!5e0!3m2!1sen!2sin!4v1758173103738!5m2!1sen!2sin" width="600" height="450" style="border:0;" allowfullscreen="" loading="lazy" referrerpolicy="no-referrer-when-downgrade"></iframe>
            </div>
        </div>
    </section>

<script>
$(document).ready(function() {

    $('#contact').on('submit', function(e) {
        let isValid = true;

        // Clear errors
        $('.error').html('');

        const name = $('#name').val().trim();
        const phone = $('#phone').val().trim();
        const email = $('#email').val().trim();
        const subject = $('#subject').val().trim();
        const message = $('#message').val().trim();
        const phoneRegex = /^[0-9]{10}$/;
        const emailRegex = /^[^\s@]+@[^\s@]+\.[^\s@]+$/;

        if (name === '') {
            $('#error_name').html('<small>Name is required.</small>');
            isValid = false;
        }

        if (phone === '' || !phoneRegex.test(phone)) {
            $('#error_phone').html('<small>Enter valid 10-digit phone number.</small>');
            isValid = false;
        }

        if (email === '' || !emailRegex.test(email)) {
            $('#error_email').html('<small>Enter valid email address.</small>');
            isValid = false;
        }

        if (subject === '') {
            $('#error_subject').html('<small>Subject is required.</small>');
            isValid = false;
        }

        if (message === '') {
            $('#error_message').html('<small>Message is required.</small>');
            isValid = false;
        }

        if (!isValid) e.preventDefault();
    });
});

</script>
@endsection