@extends('frontend.layouts.master')
@php $page= "faq" @endphp
@section('content')
    <section class="innerpage-header-wrap">
        <div class="container">
            <div class="banner-video-wrapper">
                 <video class="banner-video" autoplay="" muted="" loop="" playsinline="" preload="auto" poster=<img src="{{ asset('assets/frontend/img/banner-left-bg.jpg')}}">
                    <source src="{{ asset('assets/frontend/video/bannervideo.webm')}}" type="video/webm">
                    <img src="{{ asset('assets/frontend/img/banner-left-bg.jpg')}}" alt="Banner Background">
                </video>
            </div>
            <div class="row">
                <div class="col-lg-6">
                    <div class="innerpage-banner-heading">
                        <div class="innerpage-middlealign">
                            <h1>Frequently Asked Questions</h2>
                            <nav aria-label="breadcrumb">
                                <ol class="breadcrumb">
                                    <li class="breadcrumb-item"><a href="{{ route('frontend.home') }}"><i class="fa-solid fa-house"></i> Home</a></li>
                                    <li class="breadcrumb-item active" aria-current="page">FAQ</li>
                                </ol>
                            </nav>
                        </div>
                    </div>
                </div>
            </div>
            <img src="{{ asset('assets/frontend/img/faq-banner.jpg')}}" alt="Yeste Leadership" class="banner-image">
        </div>
    </section>



   <section class="innerpage-contanier">
    <div class="container">        
        <div class="row justify-content-center">
            <div class="col-lg-10">

                <div class="accordion accordion-flush faq-content" id="accordionFlushExample">
                    @foreach($faq as $key => $item)
                        <div class="accordion-item">
                            <button class="accordion-button collapsed" type="button"
                                data-bs-toggle="collapse"
                                data-bs-target="#faq-{{ $key }}"
                                aria-expanded="false"
                                aria-controls="faq-{{ $key }}">
                                {{ $item->question }}
                            </button>

                            <div id="faq-{{ $key }}" class="accordion-collapse collapse"
                                 data-bs-parent="#accordionFlushExample">
                                <div class="accordion-body">
                                    {!! $item->answer !!}
                                </div>
                            </div>
                        </div>
                    @endforeach
                </div>

            </div>
        </div>        
    </div>
</section>



@endsection