@extends('frontend.layouts.master')
@php $page= "find-a-job" @endphp
@section('content')
@php
    use Carbon\Carbon;
@endphp
    <form method="GET" id="jobFilterForm">   
    <section class="innerpage-header-wrap">
        <div class="container">
            <div class="banner-video-wrapper">
                 <video class="banner-video" autoplay="" muted="" loop="" playsinline="" preload="auto" poster="img/banner-left-bg.jpg')}}">
                    <source src="video/bannervideo.webm" type="video/webm">
                    <img src="{{ asset('assets/frontend/img/banner-left-bg.jpg')}}" alt="Banner Background">
                </video>
            </div>
            <div class="row">
                <div class="col-lg-6">
                    <div class="innerpage-banner-heading">
                        <div class="innerpage-middlealign">
                            <h1>Find a Job</h2>
                            <nav aria-label="breadcrumb">
                                <ol class="breadcrumb">
                                    <li class="breadcrumb-item"><a href="{{ route('frontend.home') }}"><i class="fa-solid fa-house"></i> Home</a></li>
                                    <li class="breadcrumb-item active" aria-current="page">Find a Job</li>
                                </ol>
                            </nav>
                        </div>
                    </div>
                </div>
            </div>
            <img src="{{ asset('assets/frontend/img/findjobs-banner.jpg')}}" alt="Yeste Leadership" class="banner-image">
        </div>
    </section>



    <section class="innerpage-contanier">
        <div class="container">
            
        <div class="row">
            <div class="col-lg-4 pe-lg-5">
                
                <div class="filter-sidebar-wrapper">
                    <button class="filterclose-btn" id="filterclosebtn"><i class="fa-solid fa-xmark"></i></button>
                  <h4>Filter <button id="clearFilterBtn">Clear All</button></h4>

                    <div class="search-div mt-4">
                        <h5>Search by Keywords</h5>
                         <input type="text" name="keyword" placeholder="Job title, keywords, or company" value="{{ request('keyword') }}">
                    </div>

                    <div class="checkbox-liststyle mt-4">
                        <h5>Category</h5>
                       <ul>
                        @if(isset($categories))
                        @foreach($categories as $category)
                           <li>
                                <label>
                                    <input type="checkbox" name="job_category[]" value="{{ $category['actual_value'] }}"
                                        {{ in_array($category['actual_value'], request('job_category', [])) ? 'checked' : '' }}>
                                    {{ $category['display_value'] }}
                                </label>
                            </li>
                        @endforeach
                        @endif
                        </ul>

                    </div>

                    <div class="checkbox-liststyle mt-4">
                        <h5>Job Type</h5>
                        <ul>
                        @if(isset($jobtypes))
                        @foreach($jobtypes as $jobtype)
                            <li>
                                <label>
                                    <input type="checkbox" name="jobtype[]" value="{{ $jobtype['actual_value'] }}"
                                        {{ in_array($jobtype['actual_value'], request('jobtype', [])) ? 'checked' : '' }}>
                                    {{ $jobtype['display_value'] }}
                                </label>
                            </li>
                        @endforeach
                        @endif
                        </ul>
                    </div>

                    <div class="checkbox-liststyle mt-4">
                        <h5>Experience Level(Years)</h4>
                        <select name="workexperience" id="workexperience">
                            <option value="">All</option>
                            @if(isset($workexperiences))
                            @foreach($workexperiences as $workexperience)
                                 <option value="{{ $workexperience['actual_value'] }}"
                                    {{ request('workexperience') == $workexperience['actual_value'] ? 'selected' : '' }}>
                                    {{ $workexperience['display_value'] }}
                                </option>
                            @endforeach
                            @endif
                        </select>
                    </div>
                    
                    <div class="checkbox-liststyle mt-4">
                        <h5>Sponsorship</h4>
                        <select name="sponsorship" id="sponsorship">
                            <option value="">All</option>
                            @if(isset($sponsorships))
                            @foreach($sponsorships as $sponsorship)
                                 <option value="{{ $sponsorship['actual_value'] }}"
                                    {{ request('sponsorship') == $sponsorship['actual_value'] ? 'selected' : '' }}>
                                    {{ $sponsorship['display_value'] }}
                                </option>
                            @endforeach
                            @endif
                        </select>
                    </div>

                    <div class="checkbox-liststyle mt-4">
                        <h5>Salary</h4>
                        <select name="salary" id="salary">
                            <option value="">All</option>
                            @if(isset($salaries))
                            @foreach($salaries as $salary)
                                <option value="{{  $salary['actual_value'] }}"
                                    {{ request('salary') ==  $salary['actual_value'] ? 'selected' : '' }}>
                                    {{ $salary['display_value'] }}
                                </option>
                            @endforeach
                            @endif
                        </select>
                    </div>
                </div>
                
            </div>

            <div class="col-lg-8 ps-lg-4">

                <div class="row jobsavailable-rightnow">
                    <div class="col-lg-9 col-md-9 col-7 pe-0">
                       <p>
                            <b>{{ $jobsCount }} {{ $jobsCount == 1 ? 'Job' : 'Jobs' }}</b> Available
                        </p>

                        <button class="filter-button" id="filterbtn"><i class="fa-solid fa-filter"></i></button>
                    </div>
                    <div class="col-lg-3 col-md-3 col-5">
                        <select name="sortby" id="sortby">
                            <option value="">Sort by (default)</option>
                            <option value="1"  {{ request('sortby') ==  1 ? 'selected' : '' }}>Newest</option>
                            <option value="2"  {{ request('sortby') == 2 ? 'selected' : '' }}>Oldest</option>
                        </select>
                    </div>
                </div>
                
                @foreach ($jobs as $job)
                    <div class="jobs-listing-item">
                        <div class="row">
                            <!--
                            <div class="col-xl-2 col-lg-3 col-md-3 pe-lg-0">
                                <div class="joblist-imagecon">
                                    <img src="{{ asset('assets/frontend/img/jobs-item-image.jpg') }}" alt="">
                                </div>
                            </div>
                            <div class="col-xl-10 col-lg-9 col-md-9 ps-lg-5">
                            -->
                    
                            <div class="col-xl-12 col-lg-12 col-md-12">
                                <h6>
                                    <i class="fa-regular fa-clock"></i> 
                                    {{ Carbon::parse($job['Modified_Time'])->diffForHumans() }}
                                </h6>
                                <h4>{{ $job['Posting_Title'] }}</h4>
                                <p>{{ $job['Job_Description'] }}</p>
                    
                                <ul>
                                    @if($job['Location'])
                                    <li><i class="fa-solid fa-location-dot"></i> {{ $job['Location'] }}</li>
                                    @endif
                                    @if($job['Job_Type'])
                                    <li><i class="fa-solid fa-briefcase"></i> {{ $job['Job_Type'] }}</li>
                                     @endif
                                    @if($job['Salary'])
                                    <li><i class="fa-solid fa-sack-dollar"></i> {{ $job['Salary'] }}</li>
                                    @endif
                                </ul>
                    
                                <div class="jobs-button-wrap">
                                    <a href="{{ route('frontend.applynow',$job['id']) }}" class="viewmore-btnstyle applynow">Apply Now <font><i class="fa-solid fa-angles-right"></i></font></a>
                                    <a href="{{ route('frontend.job_detail',$job['id'])}}" class="viewmore-btnstyle viewdetails">View Details <font><i class="fa-solid fa-angles-right"></i></font></a>
                                </div>
                            </div>
                        </div>
                    </div>
                    @endforeach
                    
 <div class="row">
 <div class="col-lg-3 ps-lg-4 mt-4">
     @if($noofpages>1)
{{$noofpages}} Pages
@elseif($noofpages>0)
1 Page
@endif
     
 </div>
 <div class="col-lg-9 ps-lg-4">
                
@php
    // FIX: Always read from URL
    $currentPage = (int) request()->get('page', 1);

    $totalPages = (int)$noofpages;
    $maxPagesToShow = ($totalPages < 5) ? $totalPages : 5;

    $hasMore = is_array($info) && isset($info['more_records']) ? $info['more_records'] : false;


    // Sliding window
    $start = $currentPage - floor($maxPagesToShow / 2);
    if ($start < 1) $start = 1;

    $end = $start + $maxPagesToShow - 1;
    if ($end > $totalPages) {
        $end = $totalPages;
        $start = max(1, $end - $maxPagesToShow + 1);
    }

    $pageUrl = function($pageNum) {
        return url()->current() . '?' . http_build_query(array_merge(request()->all(), ['page' => $pageNum]));
    };
@endphp

<div class="pagination-wrap">

    @if($currentPage > 1 && $totalPages > 5)
        <a href="{{ $pageUrl($currentPage - 1) }}" class="pagination-btn">Prev</a>
    @endif

    @for($i = $start; $i <= $end; $i++)
        @if($i == $currentPage)
            <span class="pagination-current active">{{ $i }}</span>
        @else
            <a class="pagination-btn" href="{{ $pageUrl($i) }}">{{ $i }}</a>
        @endif
    @endfor

    @if($hasMore && $currentPage < $totalPages)
        <a href="{{ $pageUrl($currentPage + 1) }}" class="pagination-btn">Next</a>
    @endif

</div>





 </div>
        </div>











               
                

                

                
            </div>
        </div>
            
        </div>
    </section>   
    </form>
    <script>
document.querySelectorAll('#jobFilterForm input, #jobFilterForm select')
    .forEach(el => el.addEventListener('change', () => {
        document.getElementById('jobFilterForm').submit();
    }));
</script>



@endsection