@extends('frontend.layouts.master')
@php $page= "hire-now" @endphp
@section('content')
<form method="GET" id="candidateFilterForm">
    <section class="innerpage-header-wrap">
        <div class="container">
            <div class="banner-video-wrapper">
                 <video class="banner-video" autoplay="" muted="" loop="" playsinline="" preload="auto" poster="img/banner-left-bg.jpg')}}">
                    <source src="video/bannervideo.webm" type="video/webm">
                    <img src="{{ asset('assets/frontend/img/banner-left-bg.jpg')}}" alt="Banner Background">
                </video>
            </div>
            <div class="row">
                <div class="col-lg-6">
                    <div class="innerpage-banner-heading">
                        <div class="innerpage-middlealign">
                            <h1>Hire Now</h2>
                            <nav aria-label="breadcrumb">
                                <ol class="breadcrumb">
                                    <li class="breadcrumb-item"><a href="{{ route('frontend.home') }}"><i class="fa-solid fa-house"></i> Home</a></li>
                                    <li class="breadcrumb-item active" aria-current="page">Hire Now</li>
                                </ol>
                            </nav>
                        </div>
                    </div>
                </div>
            </div>
            <img src="{{ asset('assets/frontend/img/hire-banner.jpg')}}" alt="Yeste Leadership" class="banner-image">
        </div>
    </section>



    <section class="innerpage-contanier">
        <div class="container">
            
        <div class="row">
            <div class="col-lg-4 pe-lg-5">
                <div class="filter-sidebar-wrapper">
                    <button class="filterclose-btn" id="filterclosebtn"><i class="fa-solid fa-xmark"></i></button>
                    <a href="{{ route('frontend.hire_now') }}"><h4>Filter <button>Clear All</button></h4></a>

                    <div class="search-div mt-4">
                        <h5>Search by Keywords</h5>
                        <input type="text" placeholder="Job title, keywords"  name="keyword" value="{{ request('keyword') }}">
                    </div>

                    <div class="checkbox-liststyle mt-4">
                        <h5>Filter Candidates</h5>
                        <ul>
                            @if(isset($jobtitles))
                            @foreach($jobtitles as $jobtitle)
                            <li><label><input type="checkbox" name="jobtitle[]" id="jobtitle[]" value="{{ $jobtitle['display_value'] }}"
                                        {{ in_array($jobtitle['display_value'], request('jobtitle', [])) ? 'checked' : '' }}> {{ $jobtitle['display_value'] }}</label></li>
                            @endforeach
                           @endif
                        </ul>
                    </div>
                    
                    <div class="checkbox-liststyle mt-4">
                        <h5>AHPRA Registration</h5>
                        <ul>
                            @if(isset($AHPRA_Registration))
                            @foreach($AHPRA_Registration as $ar)
                            <li><label><input type="checkbox" name="ahpra[]" id="ahpra[]" value="{{ $ar['actual_value'] }}"
                                        {{ in_array($ar['actual_value'], request('ahpra', [])) ? 'checked' : '' }}> {{ $ar['display_value'] }}</label></li>
                            @endforeach
                           @endif
                        </ul>
                    </div>

                   <!-- <div class="checkbox-liststyle mt-4">
                        <h5>Job Type</h5>
                        <ul>
                            <li><label><input type="checkbox" name="" id=""> Freelancer</label></li>
                            <li><label><input type="checkbox" name="" id=""> Full Time</label></li>
                            <li><label><input type="checkbox" name="" id=""> Part Time</label></li>
                            <li><label><input type="checkbox" name="" id=""> Temporary</label></li>
                        </ul>
                    </div>-->

                    <div class="checkbox-liststyle mt-4">
                        <h5>Experience Level</h4>
                        <select name="experiences" id="experiences">
                            <option value="">Select</option>
                            @if(isset($experiences))
                            @foreach($experiences as $experience)
                            <option value="{{ $experience['actual_value'] }}" @if($experience['actual_value'] ==request('experiences')) selected="selected" @endif >{{ $experience['display_value'] }}+ Years</option>
                            @endforeach
                            @endif
                        </select>
                    </div>
                </div>
            </div>

            <div class="col-lg-8 ps-lg-4">

                <div class="row jobsavailable-rightnow">
                    <div class="col-lg-9 col-md-9 col-7 pe-0">
                        @if($totalCount > 0)
                        <p><b>{{ $totalCount }} Candidates</b> Available </p>
                        @endif
                        <button class="filter-button" id="filterbtn"><i class="fa-solid fa-filter"></i></button>
                    </div>
                    <div class="col-lg-3 col-md-3 col-5">
                         <select name="sortby" id="sortby">
                            <option value="">Sort by (default)</option>
                            <option value="1"  {{ request('sortby') ==  1 ? 'selected' : '' }}>Newest</option>
                            <option value="2"  {{ request('sortby') == 2 ? 'selected' : '' }}>Oldest</option>
                        </select>
                    </div>
                </div>
                
                 @foreach ($candidates as $candidate)

                <div class="jobs-listing-item">
                    <div class="row">
                        <!--
                        <div class="col-xl-2 col-lg-3 col-md-3 pe-lg-0">
                            <div class="joblist-imagecon"><img src="{{ asset('assets/frontend/img/jobs-item-image.jpg')}}" alt="Candidate"></div>
                        </div>
                        <div class="col-xl-10 col-lg-9 col-md-9 ps-lg-5"> -->
                        <div class="col-xl-12 col-lg-12 col-md-12">
                            <h6><i class="fa-regular fa-clock"></i>  2 days ago</h6>
                            <h4>@if($candidate['First_Name'] != "") {{ $candidate['First_Name'] }} @endif 
                            @if($candidate['Current_Job_Title'] != "") – {{ $candidate['Current_Job_Title'] }} @endif</h4>
                            <p>@if($candidate['Candidate_Description'] != "") {{ substr($candidate['Candidate_Description'],0,100)."..." }} @endif</p>
                            <ul class="row">
                                 @if($candidate['Current_Location'] != "")
                                <li class="col-sm-4"><i class="fa-solid fa-location-dot"></i> {{ $candidate['Current_Location'] }}</li>
                                @endif
                                @if($candidate['Year_Of_Experience'] != "")
                                <li class="col-sm-4"><i class="fa-solid fa-briefcase"></i> {{ $candidate['Year_Of_Experience'] }}+ Years</li>
                                @endif
                                
                                @if($candidate['Highest_Qualification_Held'] != "")
                                <li class="col-sm-4"><i class="fa-solid fa-graduation-cap"></i> {{ $candidate['Highest_Qualification_Held'] }}</li>
                                 @endif
                                
                            </ul>
                            <div class="jobs-button-wrap">
                                <a href="{{ route('frontend.hire_now_applynow',$candidate['id']) }}" class="viewmore-btnstyle applynow">Hire Now <font><i class="fa-solid fa-angles-right"></i></font></a>
                                <a href="{{ route('frontend.hire_now_profile',$candidate['id']) }}" class="viewmore-btnstyle viewdetails">View Profile <font><i class="fa-solid fa-angles-right"></i></font></a>
                            </div>
                        </div>
                    </div>
                </div>
                @endforeach

                
 <div class="row">
 <div class="col-lg-3 ps-lg-4 mt-4">
     @if($noofpages>0)
{{$noofpages}} Pages
@endif
     
 </div>
 <div class="col-lg-9 ps-lg-4">
                
 @php
    // FIX: Always read from URL
    $currentPage = (int) request()->get('page', 1);

    $totalPages = (int)$noofpages;
    $maxPagesToShow = ($totalPages < 5) ? $totalPages : 5;

    $hasMore = is_array($info) && isset($info['more_records']) ? $info['more_records'] : false;


    // Sliding window
    $start = $currentPage - floor($maxPagesToShow / 2);
    if ($start < 1) $start = 1;

    $end = $start + $maxPagesToShow - 1;
    if ($end > $totalPages) {
        $end = $totalPages;
        $start = max(1, $end - $maxPagesToShow + 1);
    }

    $pageUrl = function($pageNum) {
        return url()->current() . '?' . http_build_query(array_merge(request()->all(), ['page' => $pageNum]));
    };
@endphp

<div class="pagination-wrap">

    @if($currentPage > 1 && $totalPages > 5)
        <a href="{{ $pageUrl($currentPage - 1) }}" class="pagination-btn">Prev</a>
    @endif

    @for($i = $start; $i <= $end; $i++)
        @if($i == $currentPage)
            <span class="pagination-current active">{{ $i }}</span>
        @else
            <a class="pagination-btn" href="{{ $pageUrl($i) }}">{{ $i }}</a>
        @endif
    @endfor

    @if($hasMore && $currentPage < $totalPages)
        <a href="{{ $pageUrl($currentPage + 1) }}" class="pagination-btn">Next</a>
    @endif

</div>


 </div>
        </div>
                

                
            </div>
        </div>
            
        </div>
    </section>   
</form>    
    
<script>
// Auto-submit for all filters EXCEPT keyword input
document.querySelectorAll('#candidateFilterForm select, #candidateFilterForm input:not(#keyword)')
    .forEach(el => el.addEventListener('change', () => {
        document.getElementById('candidateFilterForm').submit();
    }));

// Submit keyword ONLY when pressing Enter
const keywordInput = document.getElementById('keyword');

if (keywordInput) {
    keywordInput.addEventListener('keypress', function (e) {
        if (e.key === 'Enter') {
            e.preventDefault();   // prevent normal form submission
            document.getElementById('candidateFilterForm').submit();
        }
    });
}

</script>

@endsection