@extends('frontend.layouts.master')
@php $page= "hire-now" @endphp
@section('content')


@foreach($candidates as $data1)
    <section class="innerpage-header-wrap">
        <div class="container">
            <div class="banner-video-wrapper">
                 <video class="banner-video" autoplay="" muted="" loop="" playsinline="" preload="auto" poster="img/banner-left-bg.jpg">
                    <source src="video/bannervideo.webm" type="video/webm">
                    <img src="img/banner-left-bg.jpg" alt="Banner Background">
                </video>
            </div>
            <div class="row">
                <div class="col-lg-6">
                    <div class="innerpage-banner-heading">
                        <div class="innerpage-middlealign">
                            <h1>Hire Now</h2>
                            <nav aria-label="breadcrumb">
                                <ol class="breadcrumb">
                                    <li class="breadcrumb-item"><a href="index.php"><i class="fa-solid fa-house"></i> Home</a></li>
                                    <li class="breadcrumb-item" aria-current="page"><a href="hire-now.php">Hire now</a></li>
                                    <li class="breadcrumb-item active" aria-current="page">@if($data1['Current_Job_Title'] != "") {{ $data1['Current_Job_Title'] }} @endif</li>
                                </ol>
                            </nav>
                        </div>
                    </div>
                </div>
            </div>
            <img src="img/findjobs-banner.jpg" alt="Yeste Leadership" class="banner-image">
        </div>
    </section>



    <section class="innerpage-contanier">
    <div class="container">
        <div class="row">
            <!-- Candidate Detail -->
            <div class="col-lg-8 pe-lg-4 jobdetailpage-description">
                <h2 class="jobtitle">{{$data1['First_Name']}} {{$data1['Last_Name']}} @if($data1['Current_Job_Title'] != "") – {{ $data1['Current_Job_Title'] }} @endif</h2>
               @if($data1['Candidate_Description'] != "")
               {!! nl2br($data1['Candidate_Description']) !!}
               @endif

            </div>

            <!-- Sidebar -->
            <div class="col-lg-4 ps-lg-5 detailpage-right">
                <div class="jobdescription-sidebar">
                    <div class="joboverview-wrapper">
                        <h4>Candidate Overview</h4>
                        @if($data1['Year_Of_Experience'] != "")
                        <span>
                            <font><i class="fa-solid fa-briefcase"></i></font>
                            <h6>Experience:</h6>
                            <p>{{ $data1['Year_Of_Experience'] }}+ Years</p>
                        </span>
                         @endif
                         @if($data1['Current_Location'] != "")
                        <span>
                            <font><i class="fa-solid fa-location-dot"></i></font>
                            <h6>Current Location:</h6>
                            <p>{{ $data1['Current_Location'] }}</p>
                        </span>
                        @endif
                        @if($data1['Highest_Qualification_Held'] != "")
                        <span>
                            <font><i class="fa-solid fa-user-graduate"></i></font>
                            <h6>Education:</h6>
                            <p>{{ $data1['Highest_Qualification_Held'] }}</p>
                        </span>
                         @endif
                        @if($data1['Availability_to_Join'] != "")
                        <span>
                            <font><i class="fa-solid fa-clock"></i></font>
                            <h6>Availability:</h6>
                            <p>{{ $data1['Availability_to_Join'] }}</p>
                        </span>
                        @endif
                    </div>
                    <a href="{{ route('frontend.hire_now_applynow',$data1['id']) }}" class="applynow-btn">Hire Now</a>
                </div>
            </div>
        </div>
    </div>
</section>
@endforeach

@endsection