@extends('frontend.layouts.master')
@php $page= "job" @endphp
@section('content')
@php
    use Carbon\Carbon;
@endphp


    <section class="innerpage-header-wrap">
        <div class="container">
            <div class="banner-video-wrapper">
                 <video class="banner-video" autoplay="" muted="" loop="" playsinline="" preload="auto" poster="img/banner-left-bg.jpg">
                    <source src="video/bannervideo.webm" type="video/webm">
                    <img src="img/banner-left-bg.jpg" alt="Banner Background">
                </video>
            </div>
            <div class="row">
                <div class="col-lg-6">
                    <div class="innerpage-banner-heading">
                        <div class="innerpage-middlealign">
                            <h1>Find a Job</h2>
                            <nav aria-label="breadcrumb">
                                <ol class="breadcrumb">
                                    <li class="breadcrumb-item"><a href="index.php"><i class="fa-solid fa-house"></i> Home</a></li>
                                    <li class="breadcrumb-item" aria-current="page"><a href="find-a-job.php">Find a Job</a></li>
                                    <li class="breadcrumb-item active" aria-current="page">{{ $jobdetail['Posting_Title'] }} – {{ $jobdetail['Department_Name']['name'] }}</li>
                                </ol>
                            </nav>
                        </div>
                    </div>
                </div>
            </div>
            <img src="img/findjobs-banner.jpg" alt="Yeste Leadership" class="banner-image">
        </div>
    </section>



    <section class="innerpage-contanier">
        <div class="container">
            
        <div class="row">
            <div class="col-lg-8 pe-lg-4 jobdetailpage-description">
                <h2 class="jobtitle">{{ $jobdetail['Posting_Title'] }} – {{ $jobdetail['Department_Name']['name'] }}</h2>
                
                {!! $jobdetail['Job_Description'] !!}
                
            </div>

            <div class="col-lg-4 ps-lg-5 detailpage-right">
                <div class="jobdescription-sidebar">
                    <div class="joboverview-wrapper">
                        <h4>Job Overview</h4>
                        <span>
                            <font><i class="fa-solid fa-calendar-days"></i></font>
                            <h6>Date Posted:</h6>
                            <p>Posted {{ Carbon::parse($jobdetail['Modified_Time'])->diffForHumans() }} </p>
                        </span>
                        <span>
                            <font><i class="fa-solid fa-location-dot"></i></font>
                            <h6>Location:</h6>
                            <p>{{ $jobdetail['Location'] }}</p>
                        </span>
                        <span>
                            <font><i class="fa-solid fa-sack-dollar"></i></font>
                            <h6>Salary:</h6>
                            <p>{{ $jobdetail['Salary'] }}</p>
                        </span>
                        <span>
                            <font><i class="fa-solid fa-briefcase"></i></font>
                            <h6>Job Type:</h6>
                            <p>{{ $jobdetail['Job_Type'] }}</p>
                        </span>
                    </div>
                    <a href="{{ route('frontend.applynow',$jobdetail['id']) }}" class="applynow-btn">Apply Now!</a>
                </div>
            </div>
        </div>
            
        </div>
    </section>


    

@endsection