@extends('frontend.layouts.master')
@php $page= "leadership_profiles" @endphp
@section('content')



    <section class="innerpage-header-wrap">
        <div class="container">
            <div class="banner-video-wrapper">
                 <video class="banner-video" autoplay="" muted="" loop="" playsinline="" preload="auto" poster="{{ asset('assets/frontend/img/banner-left-bg.jpg')}}">
                    <source src="{{ asset('assets/frontend/video/bannervideo.webm')}}" type="video/webm">
                    <img  src="{{ asset('assets/frontend/img/banner-left-bg.jpg')}}" alt="Banner Background">
                </video>
            </div>
            <div class="row">
                <div class="col-lg-6">
                    <div class="innerpage-banner-heading">
                        <div class="innerpage-middlealign">
                            <h1>Leadership Profiles</h2>
                            <nav aria-label="breadcrumb">
                                <ol class="breadcrumb">
                                    <li class="breadcrumb-item"><a href="{{ route('frontend.home') }}"><i class="fa-solid fa-house"></i> Home</a></li>
                                    <li class="breadcrumb-item active" aria-current="page">Leadership Profiles</li>
                                </ol>
                            </nav>
                        </div>
                    </div>
                </div>
            </div>
            <img  src="{{ asset('assets/frontend/img/leadership-banner.jpg')}}" alt="Yeste Leadership" class="banner-image">
        </div>
    </section>


<section class="innerpage-contanier">
    <div class="container leadership-wrapper">

        @foreach ($leadership_profiles as $key => $profile)

            @php
                $colorClass = ($key % 2 == 0) ? 'green-profile' : 'orange-profile';
            @endphp

            <div class="ourteamitems-wrapper {{ $colorClass }} @if($key > 0) mt-4 @endif">
                <div class="row">

                    @if($key % 2 == 0)
                        <div class="col-lg-3">
                            <img src="{{ asset('storage/assets/leadership_team/photo/'.$profile->photo) }}"
                                 alt="{{ $profile->photo_text }}">
                        </div>
                    @else
                        <div class="col-lg-3 order-lg-2">
                            <img src="{{ asset('storage/assets/leadership_team/photo/'.$profile->photo) }}"
                                 alt="{{ $profile->photo_text }}">
                        </div>
                    @endif

                    <div class="col-lg-9 ps-lg-5">
                        <h3>{{ $profile->caption }}</h3>
                        {!! html_entity_decode($profile->small_description) !!}
                    </div>

                </div>
            </div>

        @endforeach

    </div>
</section>


@endsection
