<!doctype html>
<html lang="en">

<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">
    
    <title>Global Recruitment & Migration Experts | YESTE Consulting</title>
    <meta name="description" content="YESTE Consulting provides trusted recruitment, visa assistance, student placement, and migration services — guiding talent towards global success.">
    <meta name="keywords" content="recruitment agency, migration services, visa assistance, student placement, employer sponsorship, skilled migration, overseas jobs, career support, settlement services, Australia migration experts">

    <link rel="stylesheet" href="css/bootstrap.min.css">
    <link rel="stylesheet" href="css/style.css?v=1.8">


    <script src="js/bootstrap.min.js"></script>

    <script src="js/jquery.min.js"></script>
    <script src="js/slick.min.js"></script>

    <link rel="icon" type="image/ico" href="img/favoriteicon.ico">

    <link rel="stylesheet" href="fonts/fontawesome/css/all.min.css">

        <script type="text/javascript">
            jQuery("document").ready(function ($) {
                $(window).scroll(function () {
                    if ($(this).scrollTop() > 80) {
                        $('body').addClass("f-nav");
                    } else {
                        $('body').removeClass("f-nav");
                    }
                });

                $('.closebtn, #menubutton').on('click', function () {
                    $('body').toggleClass('viewmenu');
                });
            });
        </script>

</head>



<body class="home">

    <?php include('include/header.php'); ?>

    <section class="innerpage-header-wrap">
        <div class="container">
            <div class="banner-video-wrapper">
                 <video class="banner-video" autoplay="" muted="" loop="" playsinline="" preload="auto" poster="img/banner-left-bg.jpg">
                    <source src="video/bannervideo.webm" type="video/webm">
                    <img src="img/banner-left-bg.jpg" alt="Banner Background">
                </video>
            </div>
            <div class="row">
                <div class="col-lg-6">
                    <div class="innerpage-banner-heading">
                        <div class="innerpage-middlealign">
                            <h1>Privacy Policy</h2>
                            <nav aria-label="breadcrumb">
                                <ol class="breadcrumb">
                                    <li class="breadcrumb-item"><a href="index.php"><i class="fa-solid fa-house"></i> Home</a></li>
                                    <li class="breadcrumb-item active" aria-current="page">Privacy Policy</li>
                                </ol>
                            </nav>
                        </div>
                    </div>
                </div>
            </div>
            <img src="img/about-banner.jpg" alt="Yeste Leadership" class="banner-image">
        </div>
    </section>



    <section class="innerpage-contanier">
        <div class="container termsandconditions-page">
            
            <div class="row justify-content-center">
                <div class="col-lg-10">
                    
                    <p>At YESTE GLOBAL, we value your privacy and are committed to protecting your personal information. This Privacy Policy explains how we collect, use, and safeguard the data you share with us when you use our website, services, and platforms. By accessing our website or engaging with our services, you agree to the terms outlined below.</p>

                    <h4>Information We Collect</h4>
                    <p>We may collect the following types of information:</p>
                    <ul>
                        <li>Personal Information: Name, email, phone number, address, CV details, and any documents you share during applications or registrations.</li>
                        <li>Usage Data: Information on how you interact with our website, including IP address, browser type, device information, and pages visited.</li>
                        <li>Cookies & Tracking Data: Data collected through cookies and similar technologies to improve user experience and website functionality.</li>
                    </ul>

                    <h4>How We Use Your Information</h4>
                    <p>Your data is used for:</p>
                    <ul>
                        <li>Providing recruitment, visa, training, and placement services</li>
                        <li>Processing applications and registrations</li>
                        <li>Communicating updates, offers, or essential service information</li>
                        <li>Improving our website, services, and user experience</li>
                        <li>Meeting legal and compliance requirements</li>
                    </ul>

                    <h4>Sharing of Information</h4>
                    <p>We do not sell your personal information. However, we may share your data with:</p>
                    <ul>
                        <li>Trusted partners such as universities, employers, or immigration authorities when required for service delivery</li>
                        <li>Legal or regulatory authorities when required by law</li>
                        <li>Technology providers who support our website and digital operations, under strict confidentiality agreements</li>
                    </ul>

                    <h4>Data Security</h4>
                    <p>We implement appropriate security measures to protect your personal information against unauthorized access, alteration, or disclosure. While we strive to protect your data, please note that no method of electronic storage or transmission is 100% secure.</p>

                    <h4>Your Rights</h4>
                    <p>You have the right to:</p>
                    <ul>
                        <li>Access the personal information we hold about you</li>
                        <li>Request corrections to inaccurate or incomplete data</li>
                        <li>Request deletion of your data, subject to legal or contractual obligations</li>
                        <li>Withdraw consent for certain data uses at any time</li>
                    </ul>

                    <p>To exercise these rights, please contact us using the details below.</p>

                    <h3>Cookie Policy</h3>
                    <p>Our website uses cookies to improve functionality and provide a better user experience. By continuing to browse our site, you consent to our use of cookies as outlined below.</p>

                    <h4>What Are Cookies?</h4>
                    <p>Cookies are small text files stored on your device when you visit a website. They help us recognize your preferences, improve website performance, and provide a personalized experience.</p>

                    <h4>Types of Cookies We Use</h4>
                    <ul>
                        <li>Essential Cookies: Necessary for the website to function properly (e.g., login sessions, security).</li>
                        <li>Performance Cookies: Help us analyze site usage to improve functionality.</li>
                        <li>Functional Cookies: Store preferences such as language and region settings.</li>
                        <li>Advertising & Analytics Cookies: Allow us to deliver relevant content and measure the effectiveness of campaigns.</li>
                    </ul>

                    <h4>Managing Cookies</h4>
                    <p>You can control or disable cookies through your browser settings. However, please note that some website features may not function correctly without cookies.</p>

                    <h4>Updates to This Policy</h4>
                    <p>We may update this Privacy & Cookie Policy from time to time to reflect changes in our practices or legal requirements. Updates will be posted on this page with the “Last Updated” date.</p>
                
                    <h4>Contact Us</h4>
                    <p>If you have any questions about this Privacy Policy or our use of cookies, please contact us at: <a href="mailto:mail@yeste.com.au">mail@yeste.com.au</a></p>
                </div>
            </div>
            
        </div>
    </section>


    

    


    <?php include('include/footer.php'); ?>

</body>

</html>