@extends('frontend.layouts.master')
@php $page= "services" @endphp
@section('content')
<section class="innerpage-header-wrap">
        <div class="container">
            <div class="banner-video-wrapper">
                 <video class="banner-video" autoplay="" muted="" loop="" playsinline="" preload="auto" poster="img/banner-left-bg.jpg">
                    <source src="video/bannervideo.webm" type="video/webm">
                    <img src="img/banner-left-bg.jpg" alt="Banner Background">
                </video>
            </div>
            <div class="row">
                <div class="col-lg-6">
                    <div class="innerpage-banner-heading">
                        <div class="innerpage-middlealign">
                            <h1>{{ $services->caption }}</h2>
                            <nav aria-label="breadcrumb">
                                <ol class="breadcrumb">
                                    <li class="breadcrumb-item"><a href="{{ route('frontend.home') }}"><i class="fa-solid fa-house"></i> Home</a></li>
                                    <li class="breadcrumb-item active" aria-current="page">{{ $services->caption }}</li>
                                </ol>
                            </nav>
                        </div>
                    </div>
                </div>
            </div>
            <img src="{{asset('storage/assets/services/banner_photo/'.$services->banner_photo)}}" alt="{{ $services->banner_photo_text }}" class="banner-image">
        </div>
    </section>

    <section class="recruitment-topwrapper">
        <div class="container">
            
            <div class="row">
                <div class="col-lg-7 pe-lg-5">
                    <div class="services-topsection-wrap">
                    <div class="services-topsection-middlealign">
                          <p>{!!  html_entity_decode($services->small_description) !!}</span>
                            <a href="{{ $services->link }}" class="viewmore-btnstyle">{{ $services->link_caption }} <font><i class="fa-solid fa-angles-right"></i></font></a>
                    </div>
                    </div>
                </div>
                <div class="col-lg-5 ps-lg-5"><img src="{{asset('storage/assets/services/photo/'.$services->photo)}}" alt="{{ $services->photo_text }}"></div>
            </div>

        </div>
    </section>   
    
    
    <section class="ourvisaservice-include-wrapper">
        <div class="container">
            <div class="row justify-content-center">
                <div class="col-lg-12 howwehelp-student">
                    <div class="visaservice-wrap">
                        <span>
                    <h3>{{ $services->feature_caption }}</h3>
                    {!!  html_entity_decode($services->feature_description) !!}
                </span>
                </div>
            </div>
            <div class="row">

            @foreach($services_features as $index => $features)

                @if(empty($features->photo))
                    <div class="col-lg-6 pe-lg-5">
                        <h5>
                            <font>{{ $index+1 }}</font> {{ $features->caption }}
                        </h5>
                        <p>{!!  html_entity_decode($features->description) !!}</p>
                    </div>
                @else

            <div class="col-lg-4 col-md-6">
                <div class="visa-service-item">
                    <span>
                        <img src="{{ asset('storage/assets/services/features/'.$features->photo) }}" 
                             alt="{{ $features->caption }}">
                    </span>
                    <h5>{{ $features->caption }}</h5>
                    <p>{!!  html_entity_decode($features->description) !!}</p>

                </div>
            </div>
        @endif

    @endforeach

</div>

        </div>
    </section>  


    <section class="whychoose-wrapper">
        <div class="container">
            <div class="row">
                <div class="col-lg-5 pe-lg-5"><img src="{{asset('storage/assets/services/description_photo/'.$services->description_photo)}}" alt="{{ $services->description_photo_text }}"></div>
                <div class="col-lg-7 ps-lg-5">
                    <div class="whyrecruitment">
                        <div class="whyrecruitment-middle">
                            {!!  html_entity_decode($services->description) !!}
                            <a href="{{ $services->description_link }}" class="viewmore-btnstyle">{{ $services->description_link_caption }} <font><i class="fa-solid fa-angles-right"></i></font></a>
                        </div>
                    </div>
                </div>
            </div>
        </div>    
    </section>    



@endsection