@extends('frontend.layouts.master')
@php $page= "testimonials" @endphp
@section('content')
    <section class="innerpage-header-wrap">
        <div class="container">
            <div class="banner-video-wrapper">
                 <video class="banner-video" autoplay="" muted="" loop="" playsinline="" preload="auto" poster="{{ asset('assets/frontend/img/banner-left-bg.jpg')}}">
                    <source src="video/bannervideo.webm" type="video/webm">
                    <img src="{{ asset('assets/frontend/img/banner-left-bg.jpg')}}" alt="Banner Background">
                </video>
            </div>
            <div class="row">
                <div class="col-lg-6">
                    <div class="innerpage-banner-heading">
                        <div class="innerpage-middlealign">
                            <h1>Testimonials</h2>
                            <nav aria-label="breadcrumb">
                                <ol class="breadcrumb">
                                    <li class="breadcrumb-item"><a href="{{ route('frontend.home') }}"><i class="fa-solid fa-house"></i> Home</a></li>
                                    <li class="breadcrumb-item active" aria-current="page">Testimonials</li>
                                </ol>
                            </nav>
                        </div>
                    </div>
                </div>
            </div>
            <img src="{{ asset('assets/frontend/img/testimonials-banner.jpg')}}" alt="Yeste Leadership" class="banner-image">
        </div>
    </section>



    <section class="innerpage-contanier testimonials-page">
        <div class="container">
            
                <div class="row" data-masonry='{"percentPosition": true }'>
                   @foreach($testimonials as $testimonial)
                    <div class="col-lg-4 col-md-6">
                        <a href="#" class="testimonials-item">
                            <div class="testimonials-content">
                                <ul>
                                    <li><i class="fa-solid fa-star"></i></li>
                                    <li><i class="fa-solid fa-star"></i></li>
                                    <li><i class="fa-solid fa-star"></i></li>
                                    <li><i class="fa-regular fa-star"></i></li>
                                    <li><i class="fa-regular fa-star"></i></li>
                                </ul>
                                {!! html_entity_decode($testimonial->description) !!}

                            </div>
                            <div class="testimonials-footer">
                                <span>
                                    @if(!empty($testimonial->photo))
                                    

                                         <img src="{{ asset('storage/assets/testimonial/photo/'.$testimonial->photo) }}" alt="{{ $testimonial->photo_text }}">
                                    @else
                                        <img src="{{ asset('assets/frontend/img/testipropic-icon.png') }}" alt="">
                                    @endif
                                </span>
                                <h4>{{ $testimonial->name }}</h4>
                                <h6>{{ $testimonial->location }}</h6>
                            </div>
                        </a>
                    </div>
                    @endforeach
                </div>
            
        </div>
    </section>
@endsection