<?php

use Illuminate\Support\Facades\Route;
use Illuminate\Support\Facades\Artisan;

/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider and all of them will
| be assigned to the "web" middleware group. Make something great!
|
*/
//frontend


Route::get('/', 'App\Http\Controllers\frontend\HomeController@index')->name('frontend.home');
Route::get('/about', 'App\Http\Controllers\frontend\HomeController@about')->name('frontend.about');
Route::get('/services', 'App\Http\Controllers\frontend\HomeController@services')->name('frontend.services');
Route::get('/service/{seo_url}', 'App\Http\Controllers\frontend\HomeController@service')->name('frontend.service');
Route::get('/blogs', 'App\Http\Controllers\frontend\HomeController@blogs')->name('frontend.blogs');
Route::get('/blog/{seo_url}', 'App\Http\Controllers\frontend\HomeController@blog')->name('frontend.blog');
Route::get('/contact', 'App\Http\Controllers\frontend\HomeController@contact')->name('frontend.contact');
Route::post('/contactsubmit', 'App\Http\Controllers\frontend\ContactController@contactsubmit')->name('frontend.contactsubmit');
Route::get('/testimonials', 'App\Http\Controllers\frontend\HomeController@testimonials')->name('frontend.testimonials');
Route::get('/faq', 'App\Http\Controllers\frontend\HomeController@faq')->name('frontend.faq');
Route::get('/leadership-profiles', 'App\Http\Controllers\frontend\HomeController@leadership_profiles')->name('frontend.leadership_profiles');
Route::get('/hire-now', 'App\Http\Controllers\frontend\JobController@hire_now')->name('frontend.hire_now');
Route::get('/hire_now_profile/{candidate_id}', 'App\Http\Controllers\frontend\JobController@hire_now_profile')->name('frontend.hire_now_profile');
Route::get('/hire_now_applynow/{candidate_id}', 'App\Http\Controllers\frontend\JobController@hire_now_applynow')->name('frontend.hire_now_applynow');
Route::post('/hire_now_applynow/submit', 'App\Http\Controllers\frontend\JobController@hire_now_applynow_submit')->name('frontend.hire_now_applynow.submit');
Route::get('/hire_now/applynow/thankyou', 'App\Http\Controllers\frontend\JobController@hire_now_applynow_thankyou')->name('frontend.hire_now_applynow.thankyou');

Route::get('/find-a-job', 'App\Http\Controllers\frontend\JobController@find_job')->name('frontend.find_a_job');
Route::get('/applynow/{id}', 'App\Http\Controllers\frontend\JobController@applynow')->name('frontend.applynow');
Route::post('/applynow/submit', 'App\Http\Controllers\frontend\JobController@applynow_submit')->name('frontend.applynow.submit');
Route::get('/find-a-job/applynow/thankyou', 'App\Http\Controllers\frontend\JobController@applynow_thankyou')->name('frontend.applynow.thankyou');
Route::get('/job/{id}', 'App\Http\Controllers\frontend\JobController@job_detail')->name('frontend.job_detail');


Route::get('/thank-you', 'App\Http\Controllers\frontend\HomeController@thankyou')->name('frontend.thankyou');
Route::get('/zoho/callback', 'App\Http\Controllers\frontend\JobController@zohocallback')->name('frontend.zoho.callback');






Route::get('/login', 'App\Http\Controllers\backend\LoginController@showLoginForm')->name('admin.login');
Route::post('/login', 'App\Http\Controllers\backend\LoginController@login')->name('admin.login.submit');
Route::group(['prefix' => 'admin'], function () { 
    
  Route::get('/logout', 'App\Http\Controllers\backend\LoginController@logout')->name('admin.logout');

    Route::group(['middleware' => 'auth.check'], function () { 
      Route::get('/dashboard', 'App\Http\Controllers\backend\DashboardController@index')->name('admin.dashboard');


        // Banner
        Route::get('/banner/add', 'App\Http\Controllers\backend\HomeBannerController@addsettings')->name('admin.home.banner.add');
        Route::post('/banner/insert', 'App\Http\Controllers\backend\HomeBannerController@insertsettings')->name('admin.home.banner.insert');
        Route::get('/banner/view', 'App\Http\Controllers\backend\HomeBannerController@viewsettings')->name('admin.home.banner.view');
        Route::post('/banner/ajaxview', 'App\Http\Controllers\backend\HomeBannerController@ajaxview')->name('admin.home.banner.ajaxview');
        Route::get('/banner/edit/{id}', 'App\Http\Controllers\backend\HomeBannerController@editsettings')->name('admin.home.banner.edit');
        Route::post('/banner/update', 'App\Http\Controllers\backend\HomeBannerController@updatesettings')->name('admin.home.banner.update');
        Route::get('/banner/delete/{id}', 'App\Http\Controllers\backend\HomeBannerController@deletesettings')->name('admin.home.banner.delete');
   
         // Home About
        Route::get('/home_about/add', 'App\Http\Controllers\backend\HomeaboutController@addsettings')->name('admin.home.home_about.add');
        Route::post('/home_about/insert', 'App\Http\Controllers\backend\HomeaboutController@insertsettings')->name('admin.home.home_about.insert');
        Route::get('/home_about/view', 'App\Http\Controllers\backend\HomeaboutController@viewsettings')->name('admin.home.home_about.view');
        Route::post('/home_about/ajaxview', 'App\Http\Controllers\backend\HomeaboutController@ajaxview')->name('admin.home.home_about.ajaxview');
        Route::get('/home_about/edit/{id}', 'App\Http\Controllers\backend\HomeaboutController@editsettings')->name('admin.home.home_about.edit');
        Route::post('/home_about/update', 'App\Http\Controllers\backend\HomeaboutController@updatesettings')->name('admin.home.home_about.update');
        Route::get('/home_about/delete/{id}', 'App\Http\Controllers\backend\HomeaboutController@deletesettings')->name('admin.home.home_about.delete');
               

          
       Route::get('/about/add', 'App\Http\Controllers\backend\AboutUsController@addsettings')->name('admin.about.add');
      Route::post('/about/insert', 'App\Http\Controllers\backend\AboutUsController@insertsettings')->name('admin.about.insert');
      Route::get('/about/view', 'App\Http\Controllers\backend\AboutUsController@viewsettings')->name('admin.about.view');
      Route::post('/about/ajaxview', 'App\Http\Controllers\backend\AboutUsController@ajaxview')->name('admin.about.ajaxview');
      Route::get('/about/edit/{id}', 'App\Http\Controllers\backend\AboutUsController@editsettings')->name('admin.about.edit');
      Route::post('/about/update', 'App\Http\Controllers\backend\AboutUsController@updatesettings')->name('admin.about.update');
      Route::get('/about/delete/{id}', 'App\Http\Controllers\backend\AboutUsController@deletesettings')->name('admin.about.delete');

      Route::group(['prefix' => 'about'], function () { 
        Route::get('/features/view/{id}', 'App\Http\Controllers\backend\FeaturesController@viewphotos')->name('admin.about.features.view');
        Route::post('/features/ajaxviewphotos', 'App\Http\Controllers\backend\FeaturesController@ajaxviewphotos')->name('admin.about.features.ajaxviewphotos');
        Route::get('/features/add', 'App\Http\Controllers\backend\FeaturesController@addphotos')->name('admin.about.features.add');
        Route::post('/features/insert', 'App\Http\Controllers\backend\FeaturesController@insertphotos')->name('admin.about.features.insert');
        Route::get('/features/edit/{id}', 'App\Http\Controllers\backend\FeaturesController@editphotos')->name('admin.about.features.edit');
        Route::post('/features/update', 'App\Http\Controllers\backend\FeaturesController@updatephotos')->name('admin.about.features.update');
        Route::delete('/features/delete/{id}', 'App\Http\Controllers\backend\FeaturesController@deletephotos')->name('admin.about.features.delete');
  
    }); 

 	//Job   
        Route::get('/job/add', 'App\Http\Controllers\backend\JobController@addsettings')->name('admin.job.add');
        Route::post('/job/insert', 'App\Http\Controllers\backend\JobController@insertsettings')->name('admin.job.insert');
        Route::get('/job/view', 'App\Http\Controllers\backend\JobController@viewsettings')->name('admin.job.view');
        Route::match(['get', 'post'], '/job/ajaxview', 'App\Http\Controllers\backend\JobController@ajaxview')->name('admin.job.ajaxview');
        Route::get('/job/edit/{id}', 'App\Http\Controllers\backend\JobController@editsettings')->name('admin.job.edit');
        Route::post('/job/update', 'App\Http\Controllers\backend\JobController@updatesettings')->name('admin.job.update');
        Route::get('/job/delete/{id}', 'App\Http\Controllers\backend\JobController@deletesettings')->name('admin.job.delete');
        
        // Services 
        Route::get('/services/add', 'App\Http\Controllers\backend\ServicesController@addsettings')->name('admin.services.add');
        Route::post('/services/insert', 'App\Http\Controllers\backend\ServicesController@insertsettings')->name('admin.services.insert');
        Route::get('/services/view', 'App\Http\Controllers\backend\ServicesController@viewsettings')->name('admin.services.view');
        Route::post('/services/ajaxview', 'App\Http\Controllers\backend\ServicesController@ajaxview')->name('admin.services.ajaxview');
        Route::get('/services/edit/{id}', 'App\Http\Controllers\backend\ServicesController@editsettings')->name('admin.services.edit');
        Route::post('/services/update', 'App\Http\Controllers\backend\ServicesController@updatesettings')->name('admin.services.update');
        Route::get('/services/delete/{id}', 'App\Http\Controllers\backend\ServicesController@deletesettings')->name('admin.services.delete');


        Route::group(['prefix' => 'services'], function () { 
            Route::get('/features/view/{id}', 'App\Http\Controllers\backend\ServicesFeaturesController@viewphotos')->name('admin.services.features.view');
            Route::post('/features/ajaxviewphotos', 'App\Http\Controllers\backend\ServicesFeaturesController@ajaxviewphotos')->name('admin.services.features.ajaxviewphotos');
            Route::get('/features/add', 'App\Http\Controllers\backend\ServicesFeaturesController@addphotos')->name('admin.services.features.add');
            Route::post('/features/insert', 'App\Http\Controllers\backend\ServicesFeaturesController@insertphotos')->name('admin.services.features.insert');
            Route::get('/features/edit/{id}', 'App\Http\Controllers\backend\ServicesFeaturesController@editphotos')->name('admin.services.features.edit');
            Route::post('/features/update', 'App\Http\Controllers\backend\ServicesFeaturesController@updatephotos')->name('admin.services.features.update');
            Route::delete('/features/delete/{id}', 'App\Http\Controllers\backend\ServicesFeaturesController@deletephotos')->name('admin.services.features.delete');
      
        }); 

          // Excellence 
        Route::get('/excellence/add', 'App\Http\Controllers\backend\ExcellenceController@addsettings')->name('admin.excellence.add');
        Route::post('/excellence/insert', 'App\Http\Controllers\backend\ExcellenceController@insertsettings')->name('admin.excellence.insert');
        Route::get('/excellence/view', 'App\Http\Controllers\backend\ExcellenceController@viewsettings')->name('admin.excellence.view');
        Route::post('/excellence/ajaxview', 'App\Http\Controllers\backend\ExcellenceController@ajaxview')->name('admin.excellence.ajaxview');
        Route::get('/excellence/edit/{id}', 'App\Http\Controllers\backend\ExcellenceController@editsettings')->name('admin.excellence.edit');
        Route::post('/excellence/update', 'App\Http\Controllers\backend\ExcellenceController@updatesettings')->name('admin.excellence.update');
        Route::get('/excellence/delete/{id}', 'App\Http\Controllers\backend\ExcellenceController@deletesettings')->name('admin.excellence.delete');
      
        //Expertise
        Route::get('/expertise/add', 'App\Http\Controllers\backend\ExpertiseController@addsettings')->name('admin.expertise.add');
        Route::post('/expertise/insert', 'App\Http\Controllers\backend\ExpertiseController@insertsettings')->name('admin.expertise.insert');
        Route::get('/expertise/view', 'App\Http\Controllers\backend\ExpertiseController@viewsettings')->name('admin.expertise.view');
        Route::post('/expertise/ajaxview', 'App\Http\Controllers\backend\ExpertiseController@ajaxview')->name('admin.expertise.ajaxview');
        Route::get('/expertise/edit/{id}', 'App\Http\Controllers\backend\ExpertiseController@editsettings')->name('admin.expertise.edit');
        Route::post('/expertise/update', 'App\Http\Controllers\backend\ExpertiseController@updatesettings')->name('admin.expertise.update');
        Route::get('/expertise/delete/{id}', 'App\Http\Controllers\backend\ExpertiseController@deletesettings')->name('admin.expertise.delete');
      
     

        // Industry 
        Route::get('/industry/add', 'App\Http\Controllers\backend\IndustryController@addsettings')->name('admin.industry.add');
        Route::post('/industry/insert', 'App\Http\Controllers\backend\IndustryController@insertsettings')->name('admin.industry.insert');
        Route::get('/industry/view', 'App\Http\Controllers\backend\IndustryController@viewsettings')->name('admin.industry.view');
        Route::post('/industry/ajaxview', 'App\Http\Controllers\backend\IndustryController@ajaxview')->name('admin.industry.ajaxview');
        Route::get('/industry/edit/{id}', 'App\Http\Controllers\backend\IndustryController@editsettings')->name('admin.industry.edit');
        Route::post('/industry/update', 'App\Http\Controllers\backend\IndustryController@updatesettings')->name('admin.industry.update');
        Route::get('/industry/delete/{id}', 'App\Http\Controllers\backend\IndustryController@deletesettings')->name('admin.industry.delete');
    
   
    
      // Leadership Team
        Route::get('/leadership_team/add', 'App\Http\Controllers\backend\LeadershipController@addsettings')->name('admin.leadership_team.add');
        Route::post('/leadership_team/insert', 'App\Http\Controllers\backend\LeadershipController@insertsettings')->name('admin.leadership_team.insert');
        Route::get('/leadership_team/view', 'App\Http\Controllers\backend\LeadershipController@viewsettings')->name('admin.leadership_team.view');
        Route::post('/leadership_team/ajaxview', 'App\Http\Controllers\backend\LeadershipController@ajaxview')->name('admin.leadership_team.ajaxview');
        Route::get('/leadership_team/edit/{id}', 'App\Http\Controllers\backend\LeadershipController@editsettings')->name('admin.leadership_team.edit');
        Route::post('/leadership_team_updateleadership', 'App\Http\Controllers\backend\LeadershipController@updateleadership')->name('admin.leadership_team.updateleadership');
        
        Route::post('/leadership_team/ajaxview', 'App\Http\Controllers\backend\LeadershipController@ajaxview')->name('admin.leadership_team.ajaxview');
        
        Route::get('/leadership_team/delete/{id}', 'App\Http\Controllers\backend\LeadershipController@deletesettings')->name('admin.leadership_team.delete');


               // Job portal
        Route::get('/job_portal/add', 'App\Http\Controllers\backend\JobPortalController@addsettings')->name('admin.job_portal.add');
        Route::post('/job_portal/insert', 'App\Http\Controllers\backend\JobPortalController@insertsettings')->name('admin.job_portal.insert');
        Route::get('/job_portal/view', 'App\Http\Controllers\backend\JobPortalController@viewsettings')->name('admin.job_portal.view');
        Route::post('/job_portal/ajaxview', 'App\Http\Controllers\backend\JobPortalController@ajaxview')->name('admin.job_portal.ajaxview');
        Route::get('/job_portal/edit/{id}', 'App\Http\Controllers\backend\JobPortalController@editsettings')->name('admin.job_portal.edit');
        Route::post('/job_portal/update', 'App\Http\Controllers\backend\JobPortalController@updatesettings')->name('admin.job_portal.update');
        Route::get('/job_portal/delete/{id}', 'App\Http\Controllers\backend\JobPortalController@deletesettings')->name('admin.job_portal.delete');


        // Testimonials 
          Route::get('/testimonials/add', 'App\Http\Controllers\backend\TestimonialController@addsettings')->name('admin.testimonial.add');
          Route::post('/testimonials/insert', 'App\Http\Controllers\backend\TestimonialController@insertsettings')->name('admin.testimonial.insert');
          Route::get('/testimonials/view', 'App\Http\Controllers\backend\TestimonialController@viewsettings')->name('admin.testimonial.view');
          Route::post('/testimonials/ajaxview', 'App\Http\Controllers\backend\TestimonialController@ajaxview')->name('admin.testimonial.ajaxview');
          Route::get('/testimonials/edit/{id}', 'App\Http\Controllers\backend\TestimonialController@editsettings')->name('admin.testimonial.edit');
          Route::post('/testimonials/update', 'App\Http\Controllers\backend\TestimonialController@updatesettings')->name('admin.testimonial.update');
          Route::get('/testimonials/delete/{id}', 'App\Http\Controllers\backend\TestimonialController@deletesettings')->name('admin.testimonial.delete');
  
                
        //job_openings
          Route::get('/job_openings','App\Http\Controllers\backend\JobOpeningsController@index')->name('admin.job_openings');
          Route::post('/job_openings/ajaxview','App\Http\Controllers\backend\JobOpeningsController@ajaxview')->name('admin.job_openings.ajaxview');
          Route::get('/job_openings/view_popup/{id}','App\Http\Controllers\backend\JobOpeningsController@viewPopup')->name('admin.job_openings.view_popup');
          Route::post('/job_openings/update_status','App\Http\Controllers\backend\JobOpeningsController@updateStatus')->name('admin.job_openings.update_status');
          Route::get('/job_openings/delete/{id}','App\Http\Controllers\backend\JobOpeningsController@delete')->name('admin.job_openings.delete');

          
        // faq  Page 
        Route::get('/faq/add', 'App\Http\Controllers\backend\FaqController@addsettings')->name('admin.faq.add');
        Route::post('/faq/insert', 'App\Http\Controllers\backend\FaqController@insertsettings')->name('admin.faq.insert');
        Route::get('/faq/view', 'App\Http\Controllers\backend\FaqController@viewsettings')->name('admin.faq.view');
        Route::match(['get', 'post'], '/faq/ajaxview', 'App\Http\Controllers\backend\FaqController@ajaxview')->name('admin.faq.ajaxview');
        Route::get('/faq/edit/{id}', 'App\Http\Controllers\backend\FaqController@editsettings')->name('admin.faq.edit');
        Route::post('/faq/update', 'App\Http\Controllers\backend\FaqController@updatesettings')->name('admin.faq.update');
        Route::get('/faq/delete/{id}', 'App\Http\Controllers\backend\FaqController@deletesettings')->name('admin.faq.delete');

     
        //Blog
        Route::get('/blog/add', 'App\Http\Controllers\backend\BlogController@addsettings')->name('admin.blogs.add');
        Route::post('/blog/insert', 'App\Http\Controllers\backend\BlogController@insertsettings')->name('admin.blogs.insert');
        Route::get('/blog/view', 'App\Http\Controllers\backend\BlogController@viewsettings')->name('admin.blogs.view');
        Route::post('/blog/ajaxview', 'App\Http\Controllers\backend\BlogController@ajaxview')->name('admin.blogs.ajaxview');
        Route::get('/blog/edit/{id}', 'App\Http\Controllers\backend\BlogController@editsettings')->name('admin.blogs.edit');
        Route::post('/blog/update', 'App\Http\Controllers\backend\BlogController@updatesettings')->name('admin.blogs.update');
        Route::get('/blog/delete/{id}', 'App\Http\Controllers\backend\BlogController@deletesettings')->name('admin.blogs.delete');
                
      });    
      
    });
       
    //Users
    Route::get('/users/view', 'App\Http\Controllers\backend\UsersController@viewsettings')->name('admin.users.view');
    Route::post('/users/ajaxview', 'App\Http\Controllers\backend\UsersController@ajaxview')->name('admin.users.ajaxview');
    Route::get('/users/edit/{id}', 'App\Http\Controllers\backend\UsersController@editsettings')->name('admin.users.edit');
    Route::post('/users/update', 'App\Http\Controllers\backend\UsersController@updatesettings')->name('admin.users.update');
    Route::get('/users/add', 'App\Http\Controllers\backend\UsersController@addsettings')->name('admin.users.add');
    Route::post('/users/insert', 'App\Http\Controllers\backend\UsersController@insertsettings')->name('admin.users.insert');
    Route::get('/users/resetpwd/{id}', 'App\Http\Controllers\backend\UsersController@resetpwdsettings')->name('admin.users.resetpwd');
    Route::post('/users/restpwd_update', 'App\Http\Controllers\backend\UsersController@restpwd_update')->name('admin.users.restpwd_update');
    
    Route::get('/profileedit', 'App\Http\Controllers\backend\ProfileController@profileedit')->name('admin.profileedit');
    Route::post('/profileupdate', 'App\Http\Controllers\backend\ProfileController@profileupdate')->name('admin.profileupdate');
    Route::get('/changepassword', 'App\Http\Controllers\backend\ProfileController@showchangepassword')->name('admin.changepassword');
    Route::post('/changepassword_submit', 'App\Http\Controllers\backend\ProfileController@changepassword')->name('admin.changepassword_submit');
    
    
    Route::get('storage-link','App\Http\Controllers\backend\LoginController@storageLink')->name('storage.link');

Route::get('cache-clear', function () {
  Artisan::call('optimize:clear');
  request()->session()->flash('success', 'Successfully cache cleared.');
  return redirect()->back();
})->name('cache.clear');
