
<?php $page= "hire-now-applynow" ?>
<?php $__env->startSection('content'); ?>
<!-- SweetAlert2 CSS (optional - included automatically by the script too) -->
<link href="https://cdn.jsdelivr.net/npm/sweetalert2@11/dist/sweetalert2.min.css" rel="stylesheet">

<!-- SweetAlert2 JS -->
<script src="https://cdn.jsdelivr.net/npm/sweetalert2@11/dist/sweetalert2.all.min.js"></script>
    <section class="innerpage-header-wrap">
        <div class="container">
            <div class="banner-video-wrapper">
                 <video class="banner-video" autoplay="" muted="" loop="" playsinline="" preload="auto" poster="img/banner-left-bg.jpg">
                    <source src="video/bannervideo.webm" type="video/webm">
                    <img src="img/banner-left-bg.jpg" alt="Banner Background">
                </video>
            </div>
            <div class="row">
                <div class="col-lg-6">
                    <div class="innerpage-banner-heading">
                        <div class="innerpage-middlealign">
                            <h1>Apply Now</h2>
                            <nav aria-label="breadcrumb">
                                <ol class="breadcrumb">
                                    <li class="breadcrumb-item"><a href="index.php"><i class="fa-solid fa-house"></i> Home</a></li>
                                    <li class="breadcrumb-item active" aria-current="page">Apply Now</li>
                                </ol>
                            </nav>
                        </div>
                    </div>
                </div>
            </div>
            <img src="img/findjobs-banner.jpg" alt="Yeste Leadership" class="banner-image">
        </div>
    </section>



    <section class="innerpage-contanier applynowpage-wrap">
    <div class="container">
        
        <div class="row justify-content-center">
            <div class="col-lg-8">
                <div class="applynow-headings">
                    <h3>Hire the Right Talent Today</h3>
                    <p>Share your job details below - our team will help you find skilled professionals quickly and efficiently.</p>
                </div>
                
                <form action="<?php echo e(route('frontend.hire_now_applynow.submit')); ?>" id="applynowfrm" name="applynowfrm" method="POST" enctype="multipart/form-data">
                    <?php echo csrf_field(); ?>
                    <input type="hidden" name="candidate_id" id="candidate_id" value="<?php echo e($candidate_id); ?>">
                    <h4>Company Information</h4>
                    <div class="row">
                        <div class="col-lg-6 col-md-6">
                            <div class="applynowform-item">
                                <label>Company Name<span class="redcolor">*</span></label>
                                <input type="text" name="company_name" id="company_name" value="">
                                <span class="error_msg" id="error_company_name"></span>
                            </div>
                        </div>
                        <div class="col-lg-6 col-md-6">
                            <div class="applynowform-item">
                                <label>Contact Person<span class="redcolor">*</span></label>
                                <input type="text" name="contact_person" id="contact_person">
                                <span class="error_msg" id="error_contact_person"></span>
                                
                            </div>
                        </div>
                        <div class="col-lg-6 col-md-6">
                            <div class="applynowform-item">
                                <label>Email Address<span class="redcolor">*</span></label>
                                <input type="text" name="email" id="email">
                                <span class="error_msg" id="error_email"></span>
                            </div>
                        </div>
                        <div class="col-lg-6 col-md-6">
                            <div class="applynowform-item">
                                <label>Phone Number</label>
                                <input type="text" name="phone" id="phone">
                                <span class="error_msg" id="error_phone"></span>
                            </div>
                        </div>
                        <div class="col-lg-12">
                            <div class="applynowform-item">
                                <label>Company Location<span class="redcolor">*</span></label>
                                <input type="text" placeholder="City, Country" id="company_location" name="company_location">
                                <span class="error_msg" id="error_company_location"></span>
                            </div>
                        </div>
                    </div>

                    <h4>Job Details</h4>
                    <div class="row">
                        <div class="col-lg-12">
                            <div class="applynowform-item">
                                <label>Job Title / Position<span class="redcolor">*</span></label>
                                <input type="text" id="job_title" name="job_title">
                                <span class="error_msg" id="error_job_title"></span>
                            </div>
                        </div>

                        <div class="col-lg-6 col-md-6">
                            <div class="applynowform-item">
                                <label>Job Category<span class="redcolor">*</span></label>
                                <select id="job_category" name="job_category">
                                    <option value="">Select Category</option>
                                    <?php if(isset($categories)): ?>
                                    <?php $__currentLoopData = $categories; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $category): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <option value="<?php echo e($category['actual_value']); ?>"><?php echo e($category['display_value']); ?></option>
                                   <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                   <?php endif; ?>
                                </select>
                                <span class="error_msg" id="error_job_category"></span>
                            </div>
                        </div>

                        <div class="col-lg-6 col-md-6">
                            <div class="applynowform-item">
                                <label>Job Type<span class="redcolor">*</span></label>
                                <select id="job_type" name="job_type">
                                    <option value="">Select Type</option>
                                    <?php if(isset($jobtypes)): ?>
                                    <?php $__currentLoopData = $jobtypes; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $jobtype): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <option value="<?php echo e($jobtype['actual_value']); ?>"><?php echo e($jobtype['display_value']); ?></option>
                                   <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                   <?php endif; ?>
                                </select>
                                <span class="error_msg" id="error_job_type"></span>
                            </div>
                        </div>

                        <div class="col-lg-6 col-md-6">
                            <div class="applynowform-item">
                                <label>Salary Range</label>
                                <input type="text" placeholder="$40k - $60k" name="salary_range" id="salary_range">
                            </div>
                        </div>

                        <div class="col-lg-6 col-md-6">
                            <div class="applynowform-item">
                                <label>Work Location<span class="redcolor">*</span></label>
                                <input type="text" placeholder="City, Country" id="work_location" name="work_location">
                                 <span class="error_msg" id="error_work_location"></span>
                            </div>
                        </div>

                        <div class="col-lg-12">
                            <div class="applynowform-item">
                                <label>Job Description<span class="redcolor">*</span></label>
                                <textarea placeholder="Describe the key responsibilities and qualifications required." id="job_description" name="job_description"></textarea>
                                <span class="error_msg" id="error_job_description"></span>
                            </div>
                        </div>
                    </div>

                    <h4>Additional Information</h4>
                    <div class="row">
                        <div class="col-lg-12">
                            <div class="applynowform-item">
                                <label>Special Requirements (if any)</label>
                                <textarea placeholder="e.g., Visa sponsorship, language skills, certifications, etc."name="special_requirements" id="special_requirements"></textarea>
                            </div>
                        </div>
                        <div class="col-lg-12">
                            <div class="applynowform-item uploadresume">
                                <label>Upload Company Profile / Job File (optional)</label>
                                <input type="file" name="company_profile_pdf" id="company_profile_pdf">
                            </div>
                        </div>
                    </div>

                    <div class="col-lg-12 agree-terms">
                        <p><label><input type="checkbox" id="accurate"> I confirm that the information provided is accurate.<span class="redcolor">*</span></label></p>
                        <p><label><input type="checkbox" id="privacy"> I agree to the <a href="#">privacy policy</a>.<span class="redcolor">*</span></label></p>   
                        <span class="error_msg" id="error_checkbox"></span>
                    </div>

                    <div class="row justify-content-center">
                        <div class="col-lg-4 col-md-4">
                            <button class="submit-application" type="submit">Submit Job Request</button>
                        </div>
                    </div>
                </form>
            </div>
        </div>
        
    </div>
</section>

<script>
$(document).ready(function () {

    $(".submit-application").click(function (e) {
        e.preventDefault(); // prevent default form submission

        let valid = true;

        // Hide previous errors
        $(".error_msg").hide().text("");

        // Company Name
        if ($("#company_name").val().trim() === "") {
            $("#error_company_name").text("Company name is required").show();
            valid = false;
        }

        // Contact Person
        if ($("#contact_person").val().trim() === "") {
            $("#error_contact_person").text("Contact person is required").show();
            valid = false;
        }

        // Email
        let email = $("#email").val().trim();
        let emailRegex = /^\S+@\S+\.\S+$/;

        if (email === "") {
            $("#error_email").text("Email is required").show();
            valid = false;
        } else if (!emailRegex.test(email)) {
            $("#error_email").text("Enter a valid email address").show();
            valid = false;
        }

        // Phone (optional but must be valid if entered)
        let phone = $("#phone").val().trim();
        let phoneRegex = /^[0-9]{7,15}$/;

        if (phone !== "" && !phoneRegex.test(phone)) {
            $("#error_phone").text("Enter a valid phone number").show();
            valid = false;
        }

        // Company Location
        if ($("#company_location").val().trim() === "") {
            $("#error_company_location").text("Company location is required").show();
            valid = false;
        }

        // Job Title
        if ($("#job_title").val().trim() === "") {
            $("#error_job_title").text("Job title is required").show();
            valid = false;
        }

        // Job Category
        if ($("#job_category").val() === "") {
            $("#error_job_category").text("Select a job category").show();
            valid = false;
        }

        // Job Type
        if ($("#job_type").val() === "") {
            $("#error_job_type").text("Select a job type").show();
            valid = false;
        }

        // Work Location
        if ($("#work_location").val().trim() === "") {
            $("#error_work_location").text("Work location is required").show();
            valid = false;
        }

        // Job Description
        if ($("#job_description").val().trim() === "") {
            $("#error_job_description").text("Job description is required").show();
            valid = false;
        }

        // Checkboxes — Add IDs in HTML:
        // <input type="checkbox" id="accurate">
        // <input type="checkbox" id="privacy">
        
        // Checkbox Validation
        if (!$("#accurate").is(":checked") || !$("#privacy").is(":checked")) {
            $("#error_checkbox").text("You must agree to both statements").show();
            valid = false;
        }
        
       

        // Stop if validation failed
        if (!valid) {
            Swal.fire({
                icon: "error",
                title: "Form Incomplete",
                text: "Please fix the highlighted errors.",
            });
            return;
        }

        // Submit form with success popup
        Swal.fire({
            icon: "success",
            title: "Submitting...",
            text: "Your job request is being submitted.",
            timer: 1500,
            showConfirmButton: true
        }).then(() => {
            $("#applynowfrm")[0].submit();
        });
    });

});
</script>

    
<?php $__env->stopSection(); ?>
<?php echo $__env->make('frontend.layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home1/demowebtissertec/public_html/live/yeste/resources/views/frontend/hire_now_applynow.blade.php ENDPATH**/ ?>