<!doctype html>
<html lang="en">

<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">
    <?php if(isset($seo_title) && $seo_title!=""): ?>
    <title><?php echo e($seo_title); ?></title>
    <?php else: ?>
    <title>Global Recruitment & Migration Experts | YESTE Consulting</title>
    <?php endif; ?>
    <?php if(isset($seo_description) && $seo_description!=""): ?>
    <meta name="description" content="<?php echo e($seo_description); ?>">
    <?php else: ?>
    <meta name="description" content="YESTE Consulting provides trusted recruitment, visa assistance, student placement, and migration services — guiding talent towards global success.">
    <?php endif; ?>
    <?php if(isset($seo_keyword) && $seo_keyword!=""): ?>
    <meta name="keywords" content="<?php echo e($seo_keyword); ?>">
    <?php else: ?>
    <meta name="keywords" content="recruitment agency, migration services, visa assistance, student placement, employer sponsorship, skilled migration, overseas jobs, career support, settlement services, Australia migration experts">
    <?php endif; ?>
    <link rel="stylesheet" href="<?php echo e(asset('assets/frontend/css/bootstrap.min.css')); ?>?v=<?php echo e(time()); ?>" />
    <link rel="stylesheet" href="<?php echo e(asset('assets/frontend/css/style.css')); ?>?v=<?php echo e(time()); ?>" />


    <script  src="<?php echo e(asset('assets/frontend/js/bootstrap.min.js')); ?>"></script>

    <script  src="<?php echo e(asset('assets/frontend/js/jquery.min.js')); ?>"></script>
    <script  src="<?php echo e(asset('assets/frontend/js/slick.min.js')); ?>"></script>

    <link rel="icon" type="image/ico" href="<?php echo e(asset('assets/frontend/img/favoriteicon.ico')); ?>">

    <link rel="stylesheet" href="<?php echo e(asset('assets/frontend/fonts/fontawesome/css/all.min.css')); ?>">

        <script type="text/javascript">
            jQuery("document").ready(function ($) {
                $(window).scroll(function () {
                    if ($(this).scrollTop() > 80) {
                        $('body').addClass("f-nav");
                    } else {
                        $('body').removeClass("f-nav");
                    }
                });

                $('.closebtn, #menubutton').on('click', function () {
                    $('body').toggleClass('viewmenu');
                });
            });
        </script>

</head>

<body class="home">

    <section class="header-wrapper-fixed">
        <div class="header-topsection">
            <div class="container">
                <div class="row">
                    <div class="col-lg-6 col-md-6 ps-lg-5"><h6><i class="fa-brands fa-whatsapp"></i> <a href="tel:+61404380456">+61 404380456</a></h6> <h6><i class="fa-regular fa-envelope"></i> <a href="mailto:mail@recruitment@yesteglobal.com">recruitment@yesteglobal.com</a></h6></div>
                    <div class="col-lg-6 col-md-6 pe-lg-5">
                        <a href="#" data-bs-toggle="modal" data-bs-target="#staticBackdrop"><i class="fa-solid fa-right-to-bracket"></i> Sign In</a>
                        <a href="#" data-bs-toggle="modal" data-bs-target="#staticBackdrop">Register Now!</a>
                    </div>
                </div>
            </div>
        </div>
        <div class="container">
            <div class="header-wrapper">
                <div class="row">
                    <div class="col-lg-3 col-md-4 col-12"><a href="<?php echo e(route('frontend.home')); ?>" class="headerlogo"><img src="<?php echo e(asset('assets/frontend/img/logo.jpg')); ?>" alt="YESTE Consulting Pty Ltd logo – recruitment, migration & settlement experts"></a></div>
                    <div class="col-lg-9 col-md-8 col-12">
                        <nav class="navbar navbar-expand-lg">
                            <div class="container-fluid">
                                <button class="navbar-toggler" type="button" data-bs-toggle="collapse" data-bs-target="#navbarSupportedContent" aria-controls="navbarSupportedContent" aria-expanded="false" aria-label="Toggle navigation">
                                <span class="navbar-toggler-icon"></span>
                                </button>
                                <div class="collapse navbar-collapse" id="navbarSupportedContent">
                                <ul class="navbar-nav ms-auto">
                                    
                                    <li class="nav-item dropdown">
                                        <a class="nav-link dropdown-toggle aboutnav" href="#" id="navbarDropdown" role="button" data-bs-toggle="dropdown" aria-expanded="false">
                                            About Us
                                        </a>
                                        <ul class="dropdown-menu" aria-labelledby="navbarDropdown">
                                            <li><a class="dropdown-item" href="<?php echo e(route('frontend.about')); ?>">About Us</a></li>
                                            <li><a class="dropdown-item" href="<?php echo e(route('frontend.leadership_profiles')); ?>">Leadership Profiles</a></li>
                                        </ul>
                                    </li>
                                    <li class="nav-item dropdown">
                                        <a class="nav-link dropdown-toggle jobsnav" href="#" id="navbarDropdown" role="button" data-bs-toggle="dropdown" aria-expanded="false">
                                            Jobs
                                        </a>
                                        <ul class="dropdown-menu" aria-labelledby="navbarDropdown">
                                            <li><a class="dropdown-item" href="<?php echo e(route('frontend.find_a_job')); ?>">Find a Job</a></li>
                                            <li><a class="dropdown-item" href="<?php echo e(route('frontend.hire_now')); ?>">Hire Now</a></li>
                                        </ul>
                                    </li>
                                    <li class="nav-item dropdown">
                                        <a class="nav-link dropdown-toggle servicesnav" href="<?php echo e(route('frontend.services')); ?>" id="navbarDropdown" role="button" data-bs-toggle="dropdown" aria-expanded="false">
                                            Services
                                        </a>
                                        <ul class="dropdown-menu" aria-labelledby="navbarDropdown">
                                            <?php if(isset($provider_services)): ?>
                                                <?php $__currentLoopData = $provider_services; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $provider_services1): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                    <li><a class="dropdown-item" href="<?php echo e(route('frontend.service', $provider_services1->seo_url)); ?>"><?php echo e($provider_services1->caption); ?></a></li>
                                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                            <?php endif; ?>
                                        </ul>
                                    </li>
                                    <li class="nav-item">
                                        <a class="nav-link faqnav" href="<?php echo e(route('frontend.faq')); ?>">FAQ</a>
                                    </li>
                                    <li class="nav-item">
                                        <a class="nav-link blognav" href="<?php echo e(route('frontend.blogs')); ?>">Blog</a>
                                    </li>
                                    <li class="nav-item">
                                        <a class="nav-link contactnav" href="<?php echo e(route('frontend.contact')); ?>">Contact Us</a>
                                    </li>
                                </ul>
                                </div>
                            </div>
                        </nav>
                        <button class="menu-bars" id="menubutton">
                            <span></span>
                            <span></span>
                            <span></span>
                        </button>
                    </div>
                </div>
            </div>
        </div>
    </section>


    <section class="menu-wrapper-div">
        <button class="closebtn"><i class="fa-solid fa-xmark"></i></button>
        <div class="container-flud">
            <div class="row">
                <div class="col-lg-6">
                    <div class="menuwrap-middle-wrap">
                        <div class="menuwrap-middlelalign">
                            <ul>
                                <li><a href="<?php echo e(route('frontend.home')); ?>">Home</a></li>
                                <li><a href="<?php echo e(route('frontend.about')); ?>">About Us</a></li>
                                <li><a href="<?php echo e(route('frontend.services')); ?>">Services</a></li>
                                <li><a href="<?php echo e(route('frontend.faq')); ?>">Faq</a></li>
                                <li><a href="<?php echo e(route('frontend.blogs')); ?>">Blog</a></li>
                                <li><a href="<?php echo e(route('frontend.testimonials')); ?>">Testimonials</a></li>
                                <li><a href="<?php echo e(route('frontend.contact')); ?>">Contact Us</a></li>
                            </ul>
                        </div>
                    </div>
                </div>
                <div class="col-lg-6">
                    <div class="menuwrap-middle-wrap">
                        <div class="menuwrap-middlelalign menu-rightwrapper">
                            <h3>Building Bridges <br>
                                Between Talent and Employers</h3>
                            <p>Driven by passion and expertise, we help candidates find fulfilling careers and <br>employers secure the right people for their teams.</p>
                            <div class="row justify-content-center">
                                <div class="col-xl-3 col-lg-4 col-md-4">
                                    <a href="<?php echo e(route('frontend.find_a_job')); ?>">
                                        <span>
                                        <font><i class="fa-solid fa-magnifying-glass"></i></font>
                                        <h6>Find a Job</h6>
                                        </span>
                                    </a>
                                </div>
                                <div class="col-xl-3 col-lg-4 col-md-4">
                                    <a href="<?php echo e(route('frontend.hire_now')); ?>">
                                        <span>
                                        <font><i class="fa-solid fa-users"></i></font>
                                        <h6>Hire Now</h6>
                                        </span>
                                    </a>
                                </div>
                            </div>

                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>

<?php echo $__env->yieldContent('content'); ?>

<section class="footer-wrapper-div">
<div class="container">
    <div class="footer-topsection">
        <div class="row">
            <div class="col-xl-8 col-lg-8">
                <div class="ourstory-wrapper">
                    
                    <h4>Explore Our Story & Services Download <br>
                    Our Company Profile.</h4>

                    <a href="" class="download-btn">Download <font><i class="fa-solid fa-angles-right"></i></font></a>
                </div>
            </div>
            <div class="col-xl-2 col-lg-2 col-md-6 col-6">
                <a href="<?php echo e(route('frontend.find_a_job')); ?>">
                    <span>
                    <font><i class="fa-solid fa-magnifying-glass"></i></font>
                    <h6>Find a Job</h6>
                    </span>
                </a>
            </div>
            <div class="col-xl-2 col-lg-2 col-md-6 col-6">
                <a href="<?php echo e(route('frontend.hire_now')); ?>">
                    <span>
                    <font><i class="fa-solid fa-users"></i></font>
                    <h6>Hire Now</h6>
                    </span>
                </a>
            </div>
        </div>
    </div>
</div>

<div class="container footer-links-section">
    <div class="row">
        <div class="col-lg-3">
            <span class="footer-logo"><img src="<?php echo e(asset('assets/frontend/img/logo.jpg')); ?>" alt="YESTE"></span>
            <p>Bridging dreams and destinations with trusted recruitment & migration expertise.</p>
        </div>
        <div class="col-lg-2 ps-xl-5">
            <h4>Quick Links</h4>
            <ul class="quicklinks">
                <li><a href="<?php echo e(route('frontend.home')); ?>">Home</a></li>
                <li><a href="<?php echo e(route('frontend.about')); ?>">About Us</a></li>
                <li><a href="<?php echo e(route('frontend.services')); ?>">Services</a></li>
                <li><a href="<?php echo e(route('frontend.faq')); ?>">FAQ</a></li>
                <li><a href="<?php echo e(route('frontend.testimonials')); ?>">Testimonials</a></li>
                <li><a href="<?php echo e(route('frontend.blogs')); ?>">Blog</a></li>
                <li><a href="<?php echo e(route('frontend.contact')); ?>">Contact Us</a></li>
            </ul>
        </div>
        <div class="col-lg-4 pe-xl-5 col-md-6">
            <h4>Subscribe</h4>
            <p>Join our community and receive expert advice for your overseas future.</p>

            <div class="newsletter-con">
                <input type="email" placeholder="Enter your email">
                <a href=""><i class="fa-regular fa-envelope"></i> Subscribe</a>
            </div>
        </div>
        <div class="col-lg-3 col-md-6">
            <h4>Get in Touch</h4>
            <p>YESTE Global Pty Ltd <br>
            26 Ranfurlie Drive Glen Waverly  <br>
            Victoria -3150</p>
            <p><b>WhatsApp:</b> <a href="tel:+917736377714">+91 7736377714</a></p>
            <p><b>WhatsApp:</b> <a href="tel:+61404380456 ">+61 404380456 </a></p>
            <p><b>Email:</b> <a href="mailto:recruitment@yesteglobal.com">recruitment@yesteglobal.com</a></p>

                <ul class="socialmedia-icons">
                    <li><a href="#" class="fb" target="_blank"><i class="fab fa-facebook-f"></i></a></li>
                    <li><a href="#" class="li" target="_blank"><i class="fab fa-linkedin-in"></i></a></li>
                    <li><a href="#" class="tw" target="_blank"><i class="fa-brands fa-x-twitter"></i></a></li>
                    <li><a href="#" class="in" target="_blank"><i class="fab fa-instagram"></i></a></li>
                    <li><a href="#" class="em" target="_blank"><i class="fa-regular fa-envelope"></i></a></li>
                </ul>
        </div>
    </div>
</div>

<div class="footercredencials">
    <div class="container">
        <div class="row">
            <div class="col-lg-6 col-md-7"><p>2025 &copy; YESTE Global Pty Ltd. All Right Reserved.</p></div>
            <div class="col-lg-6 col-md-5"><p><a href="terms-and-conditions.php">Terms & Conditions</a> <font>|</font> <a href="privacy-policy.php">Privacy Policy</a></p></div>
        </div>
    </div>
</div>
</section>


    <script>
        jQuery(document).ready(function ($) {
            // Function to toggle visibility
            function toggleMenu(targetClass) {
                const targetMenu = $('.' + targetClass);
                const isVisible = targetMenu.css('bottom') === '0px';

                // Hide all menus
                $('.mobilemenu-wrapper').css('bottom', '-100vh');

                // Show if it wasn't already visible
                if (!isVisible) {
                    targetMenu.css('bottom', '0px');
                }
            }

           

            $('#jobs').on('click', function () {
                toggleMenu('jobs-menu');
            });

            $('#services').on('click', function () {
                toggleMenu('services-menu');
            });

            $('#more').on('click', function () {
                toggleMenu('more-menu');
            });

            // Hide any open menu when clicking on its wrapper
            $('.mobilemenu-wrapper').on('click', function () {
                $(this).css('bottom', '-100vh');
            });
        });
    </script>




<div class="mobilemenu-wrapper jobs-menu">
    <div class="mobilemenu-middlealign">
        <div class="mobilemenu-con">
            <div class="container">
                <div class="row">
                    <div class="col-md-6">
                           <a class="dropdown-item" href="<?php echo e(route('frontend.find_a_job')); ?>"> <h6>Find a Job</h6> <p>Start your journey today.</p></a>
                    </div>
                    <div class="col-md-6">
                        <a class="dropdown-item" href="<?php echo e(route('frontend.hire_now')); ?>"> <h6>Hire Now</h6> <p>Discover talent with ease.</p></a>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<div class="mobilemenu-wrapper services-menu">
    <div class="mobilemenu-middlealign">
        <div class="mobilemenu-con">
            <div class="container">
                <div class="row">
                    <?php if(isset($provider_services)): ?>
                        <?php $__currentLoopData = $provider_services; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $provider_services1): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <div class="col-md-6">
                                <a class="dropdown-item" href="<?php echo e(route('frontend.service', $provider_services1->seo_url)); ?>"> <h6><?php echo e($provider_services1->caption); ?></h6> <p><?php echo e($provider_services1->small_caption); ?></p></a>
                            </div>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    <?php endif; ?>
                </div>
            </div>
        </div>
    </div>
</div>

<div class="mobilemenu-wrapper more-menu">
    <div class="mobilemenu-middlealign">
        <div class="mobilemenu-con">
            <div class="container">
                <div class="row">
                    <div class="col-md-6">
                        <a class="dropdown-item" href="<?php echo e(route('frontend.about')); ?>"> <h6>About Us</h6> <p>Learn our story & mission.</p></a>
                    </div>
                    <div class="col-md-6">
                        <a class="dropdown-item" href="<?php echo e(route('frontend.leadership_profiles')); ?>"> <h6>Leadership Profiles</h6> <p>Meet the people driving our vision forward.</p></a>
                    </div>
                    <div class="col-md-6">
                        <a class="dropdown-item" href="<?php echo e(route('frontend.blogs')); ?>"> <h6>Blog</h6> <p>Insights, tips, and updates.</p></a>
                    </div>
                    <div class="col-md-6">
                        <a class="dropdown-item" href="<?php echo e(route('frontend.faq')); ?>"> <h6>FAQ</h6> <p>Answers to your key questions.</p></a>
                    </div>
                    <div class="col-md-6">
                        <a class="dropdown-item" href="#"> <h6>Testimonials</h6> <p>Stories of real success.</p></a>
                    </div>
                    <div class="col-md-6">
                        <a class="dropdown-item" href="#" data-bs-toggle="modal" data-bs-target="#staticBackdrop"> <h6>Register / Sign in</h6> <p>Join us and get started.</p></a>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

    <section class="footer-mobile-menu d-block d-md-none">
        <div class="container">
            <div class="row">
                <div class="col-3"><a href="<?php echo e(route('frontend.home')); ?>" id="home">Home</a></div>
                <div class="col-3"><button id="jobs">Jobs</button></div>
                <div class="col-3"><button id="services">Services</button></div>
                <div class="col-3"><a href="<?php echo e(route('frontend.contact')); ?>" id="contact">Contact</a></div>
                <div class="col-3"><button id="more">More</button></div>
            </div>
        </div>
    </section>

    <a href="https://api.whatsapp.com/send?phone=+61404380456&amp;text=Hello" target="_blank" class="whatsapp-iconbtn"><i class="fab fa-whatsapp"></i></a>


    <link href="<?php echo e(asset('assets/frontend/aos-master/dist/aos.css')); ?>" rel="stylesheet">
    <script src="<?php echo e(asset('assets/frontend/aos-master/dist/aos.js')); ?>"></script>
    <script>
        $(window).on('load', function () {
            AOS.init({
                offset: 50,
                duration: 1000,
                mirror: false,
                easing: 'ease',
                once: true, 
            });
        });
    </script>

</body>

</html><?php /**PATH /home1/demowebtissertec/public_html/live/yeste/resources/views/frontend/layouts/master.blade.php ENDPATH**/ ?>